/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.graphql;

import org.springframework.boot.autoconfigure.graphql.InvalidSchemaLocationsException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

class InvalidSchemaLocationsExceptionFailureAnalyzer
extends AbstractFailureAnalyzer<InvalidSchemaLocationsException> {
    InvalidSchemaLocationsExceptionFailureAnalyzer() {
    }

    protected FailureAnalysis analyze(Throwable rootFailure, InvalidSchemaLocationsException cause) {
        String message = "Could not find any GraphQL schema file under configured locations.";
        StringBuilder action = new StringBuilder("Check that the following locations contain schema files: " + System.lineSeparator());
        for (InvalidSchemaLocationsException.SchemaLocation schemaLocation : cause.getSchemaLocations()) {
            action.append(String.format("- '%s' (%s)" + System.lineSeparator(), schemaLocation.getUri(), schemaLocation.getLocation()));
        }
        return new FailureAnalysis(message, action.toString(), (Throwable)((Object)cause));
    }
}

