/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.graphql;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public class InvalidSchemaLocationsException
extends NestedRuntimeException {
    private final List<SchemaLocation> schemaLocations;

    public InvalidSchemaLocationsException(String[] locations, ResourcePatternResolver resolver) {
        this(locations, resolver, null);
    }

    public InvalidSchemaLocationsException(String[] locations, ResourcePatternResolver resolver, Throwable cause) {
        super("No schema file could be found in the provided locations.", cause);
        Assert.notEmpty((Object[])locations, (String)"locations should not be empty");
        Assert.notNull((Object)resolver, (String)"resolver should not be null");
        ArrayList<SchemaLocation> providedLocations = new ArrayList<SchemaLocation>();
        for (String location : locations) {
            try {
                String uri = resolver.getResource(location).getURI().toASCIIString();
                providedLocations.add(new SchemaLocation(location, uri));
            }
            catch (IOException ex) {
                providedLocations.add(new SchemaLocation(location, ""));
            }
        }
        this.schemaLocations = Collections.unmodifiableList(providedLocations);
    }

    public List<SchemaLocation> getSchemaLocations() {
        return this.schemaLocations;
    }

    public static class SchemaLocation {
        private final String location;
        private final String uri;

        SchemaLocation(String location, String uri) {
            this.location = location;
            this.uri = uri;
        }

        public String getLocation() {
            return this.location;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

