/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.graphql;

import graphql.GraphQL;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.schema.visibility.NoIntrospectionGraphqlFieldVisibility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.graphql.GraphQlProperties;
import org.springframework.boot.autoconfigure.graphql.GraphQlSourceBuilderCustomizer;
import org.springframework.boot.autoconfigure.graphql.InvalidSchemaLocationsException;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.graphql.GraphQlService;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerConfigurer;
import org.springframework.graphql.execution.BatchLoaderRegistry;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.DataLoaderRegistrar;
import org.springframework.graphql.execution.DefaultBatchLoaderRegistry;
import org.springframework.graphql.execution.ExecutionGraphQlService;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.MissingSchemaException;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={GraphQL.class, GraphQlSource.class})
@EnableConfigurationProperties(value={GraphQlProperties.class})
public class GraphQlAutoConfiguration {
    private static final Log logger = LogFactory.getLog(GraphQlAutoConfiguration.class);
    private final BatchLoaderRegistry batchLoaderRegistry = new DefaultBatchLoaderRegistry();

    @Bean
    @ConditionalOnMissingBean
    public GraphQlSource graphQlSource(ResourcePatternResolver resourcePatternResolver, GraphQlProperties properties, ObjectProvider<DataFetcherExceptionResolver> exceptionResolversProvider, ObjectProvider<Instrumentation> instrumentationsProvider, ObjectProvider<RuntimeWiringConfigurer> wiringConfigurers, ObjectProvider<GraphQlSourceBuilderCustomizer> sourceCustomizers) {
        List<Resource> schemaResources = this.resolveSchemaResources(resourcePatternResolver, properties.getSchema().getLocations(), properties.getSchema().getFileExtensions());
        GraphQlSource.Builder builder = GraphQlSource.builder().schemaResources(schemaResources.toArray(new Resource[0])).exceptionResolvers(exceptionResolversProvider.orderedStream().collect(Collectors.toList())).instrumentation(instrumentationsProvider.orderedStream().collect(Collectors.toList()));
        if (!properties.getSchema().getIntrospection().isEnabled()) {
            builder.configureRuntimeWiring(wiring -> wiring.fieldVisibility((GraphqlFieldVisibility)NoIntrospectionGraphqlFieldVisibility.NO_INTROSPECTION_FIELD_VISIBILITY));
        }
        wiringConfigurers.orderedStream().forEach(arg_0 -> ((GraphQlSource.Builder)builder).configureRuntimeWiring(arg_0));
        sourceCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        try {
            return builder.build();
        }
        catch (MissingSchemaException exc) {
            throw new InvalidSchemaLocationsException(properties.getSchema().getLocations(), resourcePatternResolver, exc);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public BatchLoaderRegistry batchLoaderRegistry() {
        return this.batchLoaderRegistry;
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQlService graphQlService(GraphQlSource graphQlSource) {
        ExecutionGraphQlService service = new ExecutionGraphQlService(graphQlSource);
        service.addDataLoaderRegistrar((DataLoaderRegistrar)this.batchLoaderRegistry);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    public AnnotatedControllerConfigurer annotatedControllerConfigurer() {
        AnnotatedControllerConfigurer annotatedControllerConfigurer = new AnnotatedControllerConfigurer();
        annotatedControllerConfigurer.setConversionService((ConversionService)new DefaultFormattingConversionService());
        return annotatedControllerConfigurer;
    }

    private List<Resource> resolveSchemaResources(ResourcePatternResolver resolver, String[] schemaLocations, String[] fileExtensions) {
        ArrayList<Resource> schemaResources = new ArrayList<Resource>();
        for (String location : schemaLocations) {
            for (String extension : fileExtensions) {
                String resourcePattern = location + "*" + extension;
                try {
                    schemaResources.addAll(Arrays.asList(resolver.getResources(resourcePattern)));
                }
                catch (IOException ex) {
                    logger.debug((Object)("Could not resolve schema location: '" + resourcePattern + "'"), (Throwable)ex);
                }
            }
        }
        return schemaResources;
    }
}

