/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.DataSourceInitializationMode;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.datasource")
public class DataSourceProperties
implements BeanClassLoaderAware,
InitializingBean {
    private ClassLoader classLoader;
    private String name;
    private boolean generateUniqueName = true;
    private Class<? extends DataSource> type;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String jndiName;
    @Deprecated
    private DataSourceInitializationMode initializationMode = DataSourceInitializationMode.EMBEDDED;
    @Deprecated
    private String platform = "all";
    private List<String> schema;
    @Deprecated
    private String schemaUsername;
    @Deprecated
    private String schemaPassword;
    @Deprecated
    private List<String> data;
    @Deprecated
    private String dataUsername;
    @Deprecated
    private String dataPassword;
    @Deprecated
    private boolean continueOnError = false;
    @Deprecated
    private String separator = ";";
    @Deprecated
    private Charset sqlScriptEncoding;
    private EmbeddedDatabaseConnection embeddedDatabaseConnection;
    private Xa xa = new Xa();
    private String uniqueName;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.embeddedDatabaseConnection == null) {
            this.embeddedDatabaseConnection = EmbeddedDatabaseConnection.get((ClassLoader)this.classLoader);
        }
    }

    public DataSourceBuilder<?> initializeDataSourceBuilder() {
        return DataSourceBuilder.create((ClassLoader)this.getClassLoader()).type(this.getType()).driverClassName(this.determineDriverClassName()).url(this.determineUrl()).username(this.determineUsername()).password(this.determinePassword());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGenerateUniqueName() {
        return this.generateUniqueName;
    }

    public void setGenerateUniqueName(boolean generateUniqueName) {
        this.generateUniqueName = generateUniqueName;
    }

    public Class<? extends DataSource> getType() {
        return this.type;
    }

    public void setType(Class<? extends DataSource> type) {
        this.type = type;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String determineDriverClassName() {
        if (StringUtils.hasText((String)this.driverClassName)) {
            Assert.state((boolean)this.driverClassIsLoadable(), () -> "Cannot load driver class: " + this.driverClassName);
            return this.driverClassName;
        }
        String driverClassName = null;
        if (StringUtils.hasText((String)this.url)) {
            driverClassName = DatabaseDriver.fromJdbcUrl((String)this.url).getDriverClassName();
        }
        if (!StringUtils.hasText(driverClassName)) {
            driverClassName = this.embeddedDatabaseConnection.getDriverClassName();
        }
        if (!StringUtils.hasText((String)driverClassName)) {
            throw new DataSourceBeanCreationException("Failed to determine a suitable driver class", this, this.embeddedDatabaseConnection);
        }
        return driverClassName;
    }

    private boolean driverClassIsLoadable() {
        try {
            ClassUtils.forName((String)this.driverClassName, null);
            return true;
        }
        catch (UnsupportedClassVersionError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String determineUrl() {
        String url;
        if (StringUtils.hasText((String)this.url)) {
            return this.url;
        }
        String databaseName = this.determineDatabaseName();
        String string = url = databaseName != null ? this.embeddedDatabaseConnection.getUrl(databaseName) : null;
        if (!StringUtils.hasText((String)url)) {
            throw new DataSourceBeanCreationException("Failed to determine suitable jdbc url", this, this.embeddedDatabaseConnection);
        }
        return url;
    }

    public String determineDatabaseName() {
        if (this.generateUniqueName) {
            if (this.uniqueName == null) {
                this.uniqueName = UUID.randomUUID().toString();
            }
            return this.uniqueName;
        }
        if (StringUtils.hasLength((String)this.name)) {
            return this.name;
        }
        if (this.embeddedDatabaseConnection != EmbeddedDatabaseConnection.NONE) {
            return "testdb";
        }
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String determineUsername() {
        if (StringUtils.hasText((String)this.username)) {
            return this.username;
        }
        if (EmbeddedDatabaseConnection.isEmbedded((String)this.determineDriverClassName(), (String)this.determineUrl())) {
            return "sa";
        }
        return null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String determinePassword() {
        if (StringUtils.hasText((String)this.password)) {
            return this.password;
        }
        if (EmbeddedDatabaseConnection.isEmbedded((String)this.determineDriverClassName(), (String)this.determineUrl())) {
            return "";
        }
        return null;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.sql.init.enabled")
    public DataSourceInitializationMode getInitializationMode() {
        return this.initializationMode;
    }

    @Deprecated
    public void setInitializationMode(DataSourceInitializationMode initializationMode) {
        this.initializationMode = initializationMode;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.sql.init.platform")
    public String getPlatform() {
        return this.platform;
    }

    @Deprecated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.sql.init.ddlScriptLocations")
    public List<String> getSchema() {
        return this.schema;
    }

    @Deprecated
    public void setSchema(List<String> schema) {
        this.schema = schema;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.sql.init.username")
    public String getSchemaUsername() {
        return this.schemaUsername;
    }

    @Deprecated
    public void setSchemaUsername(String schemaUsername) {
        this.schemaUsername = schemaUsername;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.sql.init.password")
    public String getSchemaPassword() {
        return this.schemaPassword;
    }

    @Deprecated
    public void setSchemaPassword(String schemaPassword) {
        this.schemaPassword = schemaPassword;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.sql.init.dmlScriptLocations")
    public List<String> getData() {
        return this.data;
    }

    @Deprecated
    public void setData(List<String> data) {
        this.data = data;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.sql.init.username")
    public String getDataUsername() {
        return this.dataUsername;
    }

    @Deprecated
    public void setDataUsername(String dataUsername) {
        this.dataUsername = dataUsername;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.sql.init.password")
    public String getDataPassword() {
        return this.dataPassword;
    }

    @Deprecated
    public void setDataPassword(String dataPassword) {
        this.dataPassword = dataPassword;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.sql.init.continue-on-error")
    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    @Deprecated
    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.sql.init.separator")
    public String getSeparator() {
        return this.separator;
    }

    @Deprecated
    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.sql.init.encoding")
    public Charset getSqlScriptEncoding() {
        return this.sqlScriptEncoding;
    }

    @Deprecated
    public void setSqlScriptEncoding(Charset sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    public EmbeddedDatabaseConnection getEmbeddedDatabaseConnection() {
        return this.embeddedDatabaseConnection;
    }

    public void setEmbeddedDatabaseConnection(EmbeddedDatabaseConnection embeddedDatabaseConnection) {
        this.embeddedDatabaseConnection = embeddedDatabaseConnection;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Xa getXa() {
        return this.xa;
    }

    public void setXa(Xa xa) {
        this.xa = xa;
    }

    static class DataSourceBeanCreationException
    extends BeanCreationException {
        private final DataSourceProperties properties;
        private final EmbeddedDatabaseConnection connection;

        DataSourceBeanCreationException(String message, DataSourceProperties properties, EmbeddedDatabaseConnection connection) {
            super(message);
            this.properties = properties;
            this.connection = connection;
        }

        DataSourceProperties getProperties() {
            return this.properties;
        }

        EmbeddedDatabaseConnection getConnection() {
            return this.connection;
        }
    }

    public static class Xa {
        private String dataSourceClassName;
        private Map<String, String> properties = new LinkedHashMap<String, String>();

        public String getDataSourceClassName() {
            return this.dataSourceClassName;
        }

        public void setDataSourceClassName(String dataSourceClassName) {
            this.dataSourceClassName = dataSourceClassName;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }
    }
}

