/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.hibernate.engine.spi.SessionImplementor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceInitializer;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.autoconfigure.orm.jpa.SpringBootSchemaManagementTool;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ResourceLoader;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class, EntityManager.class, SessionImplementor.class})
@EnableConfigurationProperties(value={JpaProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@Import(value={HibernateJpaConfiguration.class})
public class HibernateJpaAutoConfiguration {

    @ConditionalOnProperty(prefix="spring.datasource", name={"initialization-order"}, havingValue="after-jpa", matchIfMissing=false)
    static class AfterJpaDataSourceInitializationConfiguration {
        AfterJpaDataSourceInitializationConfiguration() {
        }

        @Bean
        HibernatePropertiesCustomizer dataSourceInitializationCustomizer(DataSource dataSource, DataSourceProperties properties, ResourceLoader resourceLoader) {
            return hibernateProperties -> hibernateProperties.put("hibernate.schema_management_tool", new SpringBootSchemaManagementTool(new DataSourceInitializer(dataSource, properties, resourceLoader)));
        }
    }
}

