/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceInitialization;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcOperationsDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.NamedParameterJdbcOperationsDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.orm.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSingleCandidate(value=DataSource.class)
class DataSourceInitializationConfiguration {
    DataSourceInitializationConfiguration() {
    }

    @ConditionalOnClass(value={NamedParameterJdbcOperations.class})
    protected static class DataSourceInitializationNamedParameterJdbcOperationsDependsOnPostProcessor
    extends NamedParameterJdbcOperationsDependsOnPostProcessor {
        public DataSourceInitializationNamedParameterJdbcOperationsDependsOnPostProcessor() {
            super(DataSourceInitialization.class);
        }
    }

    @ConditionalOnClass(value={JdbcOperations.class})
    static class DataSourceInitializationJdbcOperationsDependsOnPostProcessor
    extends JdbcOperationsDependsOnPostProcessor {
        DataSourceInitializationJdbcOperationsDependsOnPostProcessor() {
            super(DataSourceInitialization.class);
        }
    }

    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class, EntityManagerFactory.class})
    static class DataSourceInitializationEntityManagerFactoryDependsOnPostProcessor
    extends EntityManagerFactoryDependsOnPostProcessor {
        DataSourceInitializationEntityManagerFactoryDependsOnPostProcessor() {
            super(DataSourceInitialization.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.datasource", name={"initialization-order"}, havingValue="before-jpa", matchIfMissing=true)
    @Import(value={DataSourceInitializationJdbcOperationsDependsOnPostProcessor.class, DataSourceInitializationNamedParameterJdbcOperationsDependsOnPostProcessor.class, DataSourceInitializationEntityManagerFactoryDependsOnPostProcessor.class})
    static class BeforeJpaDataSourceInitializationConfiguration {
        BeforeJpaDataSourceInitializationConfiguration() {
        }

        @Bean
        DataSourceInitialization dataSourceInitialization(DataSource dataSource, DataSourceProperties properties) {
            return new DataSourceInitialization(dataSource, properties);
        }
    }
}

