/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import java.sql.DatabaseMetaData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.jooq.DSLContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.flyway.FlywayConfigurationCustomizer;
import org.springframework.boot.autoconfigure.flyway.FlywayDataSource;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationInitializer;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationScriptMissingException;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.autoconfigure.flyway.FlywaySchemaManagementProvider;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcOperationsDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.NamedParameterJdbcOperationsDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.jooq.DslContextDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.orm.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Flyway.class})
@Conditional(value={FlywayDataSourceCondition.class})
@ConditionalOnProperty(prefix="spring.flyway", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@Import(value={FlywayEntityManagerFactoryDependsOnPostProcessor.class, FlywayJdbcOperationsDependsOnPostProcessor.class, FlywayNamedParameterJdbcOperationsDependencyConfiguration.class, FlywayDslContextDependsOnPostProcessor.class})
public class FlywayAutoConfiguration {
    @Bean
    @ConfigurationPropertiesBinding
    public StringOrNumberToMigrationVersionConverter stringOrNumberMigrationVersionConverter() {
        return new StringOrNumberToMigrationVersionConverter();
    }

    @Bean
    public FlywaySchemaManagementProvider flywayDefaultDdlModeProvider(ObjectProvider<Flyway> flyways) {
        return new FlywaySchemaManagementProvider((Iterable<Flyway>)flyways);
    }

    static final class FlywayDataSourceCondition
    extends AnyNestedCondition {
        FlywayDataSourceCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="spring.flyway", name={"url"}, matchIfMissing=false)
        private static final class FlywayUrlCondition {
            private FlywayUrlCondition() {
            }
        }

        @ConditionalOnBean(value={DataSource.class})
        private static final class DataSourceBeanCondition {
            private DataSourceBeanCondition() {
            }
        }
    }

    private static class StringOrNumberToMigrationVersionConverter
    implements GenericConverter {
        private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES;

        private StringOrNumberToMigrationVersionConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return CONVERTIBLE_TYPES;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            String value = ObjectUtils.nullSafeToString((Object)source);
            return MigrationVersion.fromVersion((String)value);
        }

        static {
            HashSet<GenericConverter.ConvertiblePair> types = new HashSet<GenericConverter.ConvertiblePair>(2);
            types.add(new GenericConverter.ConvertiblePair(String.class, MigrationVersion.class));
            types.add(new GenericConverter.ConvertiblePair(Number.class, MigrationVersion.class));
            CONVERTIBLE_TYPES = Collections.unmodifiableSet(types);
        }
    }

    private static class LocationResolver {
        private static final String VENDOR_PLACEHOLDER = "{vendor}";
        private final DataSource dataSource;

        LocationResolver(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        List<String> resolveLocations(List<String> locations) {
            if (this.usesVendorLocation(locations)) {
                DatabaseDriver databaseDriver = this.getDatabaseDriver();
                return this.replaceVendorLocations(locations, databaseDriver);
            }
            return locations;
        }

        private List<String> replaceVendorLocations(List<String> locations, DatabaseDriver databaseDriver) {
            if (databaseDriver == DatabaseDriver.UNKNOWN) {
                return locations;
            }
            String vendor = databaseDriver.getId();
            return locations.stream().map(location -> location.replace(VENDOR_PLACEHOLDER, vendor)).collect(Collectors.toList());
        }

        private DatabaseDriver getDatabaseDriver() {
            try {
                String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, DatabaseMetaData::getURL);
                return DatabaseDriver.fromJdbcUrl((String)url);
            }
            catch (MetaDataAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private boolean usesVendorLocation(Collection<String> locations) {
            for (String location : locations) {
                if (!location.contains(VENDOR_PLACEHOLDER)) continue;
                return true;
            }
            return false;
        }
    }

    @ConditionalOnClass(value={DSLContext.class})
    @ConditionalOnBean(value={DSLContext.class})
    protected static class FlywayDslContextDependsOnPostProcessor
    extends DslContextDependsOnPostProcessor {
        public FlywayDslContextDependsOnPostProcessor() {
            super(Flyway.class);
        }
    }

    @ConditionalOnClass(value={NamedParameterJdbcOperations.class})
    @ConditionalOnBean(value={NamedParameterJdbcOperations.class})
    protected static class FlywayNamedParameterJdbcOperationsDependencyConfiguration
    extends NamedParameterJdbcOperationsDependsOnPostProcessor {
        public FlywayNamedParameterJdbcOperationsDependencyConfiguration() {
            super(Flyway.class);
        }
    }

    @ConditionalOnClass(value={JdbcOperations.class})
    @ConditionalOnBean(value={JdbcOperations.class})
    static class FlywayJdbcOperationsDependsOnPostProcessor
    extends JdbcOperationsDependsOnPostProcessor {
        FlywayJdbcOperationsDependsOnPostProcessor() {
            super(Flyway.class);
        }
    }

    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    static class FlywayEntityManagerFactoryDependsOnPostProcessor
    extends EntityManagerFactoryDependsOnPostProcessor {
        FlywayEntityManagerFactoryDependsOnPostProcessor() {
            super(Flyway.class);
        }
    }

    @ConditionalOnClass(value={DSLContext.class})
    @ConditionalOnBean(value={DSLContext.class})
    static class FlywayMigrationInitializerDslContextDependsOnPostProcessor
    extends DslContextDependsOnPostProcessor {
        FlywayMigrationInitializerDslContextDependsOnPostProcessor() {
            super(FlywayMigrationInitializer.class);
        }
    }

    @ConditionalOnClass(value={NamedParameterJdbcOperations.class})
    @ConditionalOnBean(value={NamedParameterJdbcOperations.class})
    static class FlywayMigrationInitializerNamedParameterJdbcOperationsDependsOnPostProcessor
    extends NamedParameterJdbcOperationsDependsOnPostProcessor {
        FlywayMigrationInitializerNamedParameterJdbcOperationsDependsOnPostProcessor() {
            super(FlywayMigrationInitializer.class);
        }
    }

    @ConditionalOnClass(value={JdbcOperations.class})
    @ConditionalOnBean(value={JdbcOperations.class})
    static class FlywayMigrationInitializerJdbcOperationsDependsOnPostProcessor
    extends JdbcOperationsDependsOnPostProcessor {
        FlywayMigrationInitializerJdbcOperationsDependsOnPostProcessor() {
            super(FlywayMigrationInitializer.class);
        }
    }

    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    static class FlywayMigrationInitializerEntityManagerFactoryDependsOnPostProcessor
    extends EntityManagerFactoryDependsOnPostProcessor {
        FlywayMigrationInitializerEntityManagerFactoryDependsOnPostProcessor() {
            super(FlywayMigrationInitializer.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={Flyway.class})
    @EnableConfigurationProperties(value={DataSourceProperties.class, FlywayProperties.class})
    @Import(value={FlywayMigrationInitializerEntityManagerFactoryDependsOnPostProcessor.class, FlywayMigrationInitializerJdbcOperationsDependsOnPostProcessor.class, FlywayMigrationInitializerNamedParameterJdbcOperationsDependsOnPostProcessor.class, FlywayMigrationInitializerDslContextDependsOnPostProcessor.class})
    public static class FlywayConfiguration {
        @Bean
        public Flyway flyway(FlywayProperties properties, DataSourceProperties dataSourceProperties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, @FlywayDataSource ObjectProvider<DataSource> flywayDataSource, ObjectProvider<FlywayConfigurationCustomizer> fluentConfigurationCustomizers, ObjectProvider<JavaMigration> javaMigrations, ObjectProvider<Callback> callbacks) {
            FluentConfiguration configuration = new FluentConfiguration(resourceLoader.getClassLoader());
            DataSource dataSourceToMigrate = this.configureDataSource(configuration, properties, dataSourceProperties, (DataSource)flywayDataSource.getIfAvailable(), (DataSource)dataSource.getIfUnique());
            this.checkLocationExists(dataSourceToMigrate, properties, resourceLoader);
            this.configureProperties(configuration, properties);
            List<Callback> orderedCallbacks = callbacks.orderedStream().collect(Collectors.toList());
            this.configureCallbacks(configuration, orderedCallbacks);
            fluentConfigurationCustomizers.orderedStream().forEach(customizer -> customizer.customize(configuration));
            this.configureFlywayCallbacks(configuration, orderedCallbacks);
            List<JavaMigration> migrations = javaMigrations.stream().collect(Collectors.toList());
            this.configureJavaMigrations(configuration, migrations);
            return configuration.load();
        }

        private DataSource configureDataSource(FluentConfiguration configuration, FlywayProperties properties, DataSourceProperties dataSourceProperties, DataSource flywayDataSource, DataSource dataSource) {
            if (properties.isCreateDataSource()) {
                String url = this.getProperty(properties::getUrl, dataSourceProperties::determineUrl);
                String user = this.getProperty(properties::getUser, dataSourceProperties::determineUsername);
                String password = this.getProperty(properties::getPassword, dataSourceProperties::determinePassword);
                configuration.dataSource(url, user, password);
            } else if (flywayDataSource != null) {
                configuration.dataSource(flywayDataSource);
            } else {
                configuration.dataSource(dataSource);
            }
            return configuration.getDataSource();
        }

        private void checkLocationExists(DataSource dataSource, FlywayProperties properties, ResourceLoader resourceLoader) {
            List<String> locations;
            if (properties.isCheckLocation() && !this.hasAtLeastOneLocation(resourceLoader, locations = new LocationResolver(dataSource).resolveLocations(properties.getLocations()))) {
                throw new FlywayMigrationScriptMissingException(locations);
            }
        }

        private void configureProperties(FluentConfiguration configuration, FlywayProperties properties) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            String[] locations = new LocationResolver(configuration.getDataSource()).resolveLocations(properties.getLocations()).toArray(new String[0]);
            map.from((Object)locations).to(arg_0 -> ((FluentConfiguration)configuration).locations(arg_0));
            map.from((Object)properties.getEncoding()).to(arg_0 -> ((FluentConfiguration)configuration).encoding(arg_0));
            map.from((Object)properties.getConnectRetries()).to(arg_0 -> ((FluentConfiguration)configuration).connectRetries(arg_0));
            map.from((Object)properties.getLockRetryCount()).to(lockRetryCount -> configuration.lockRetryCount(lockRetryCount.intValue()));
            map.from((Object)properties.getDefaultSchema()).to(schema -> configuration.defaultSchema(schema));
            map.from(properties.getSchemas()).as(StringUtils::toStringArray).to(arg_0 -> ((FluentConfiguration)configuration).schemas(arg_0));
            this.configureCreateSchemas(configuration, properties.isCreateSchemas());
            map.from((Object)properties.getTable()).to(arg_0 -> ((FluentConfiguration)configuration).table(arg_0));
            map.from((Object)properties.getTablespace()).whenNonNull().to(tablespace -> configuration.tablespace(tablespace));
            map.from((Object)properties.getBaselineDescription()).to(arg_0 -> ((FluentConfiguration)configuration).baselineDescription(arg_0));
            map.from((Object)properties.getBaselineVersion()).to(arg_0 -> ((FluentConfiguration)configuration).baselineVersion(arg_0));
            map.from((Object)properties.getInstalledBy()).to(arg_0 -> ((FluentConfiguration)configuration).installedBy(arg_0));
            map.from(properties.getPlaceholders()).to(arg_0 -> ((FluentConfiguration)configuration).placeholders(arg_0));
            map.from((Object)properties.getPlaceholderPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderPrefix(arg_0));
            map.from((Object)properties.getPlaceholderSuffix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderSuffix(arg_0));
            map.from((Object)properties.isPlaceholderReplacement()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderReplacement(arg_0));
            map.from((Object)properties.getSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationPrefix(arg_0));
            map.from(properties.getSqlMigrationSuffixes()).as(StringUtils::toStringArray).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSuffixes(arg_0));
            map.from((Object)properties.getSqlMigrationSeparator()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSeparator(arg_0));
            map.from((Object)properties.getRepeatableSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).repeatableSqlMigrationPrefix(arg_0));
            map.from((Object)properties.getTarget()).to(arg_0 -> ((FluentConfiguration)configuration).target(arg_0));
            map.from((Object)properties.isBaselineOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).baselineOnMigrate(arg_0));
            map.from((Object)properties.isCleanDisabled()).to(arg_0 -> ((FluentConfiguration)configuration).cleanDisabled(arg_0));
            map.from((Object)properties.isCleanOnValidationError()).to(arg_0 -> ((FluentConfiguration)configuration).cleanOnValidationError(arg_0));
            map.from((Object)properties.isGroup()).to(arg_0 -> ((FluentConfiguration)configuration).group(arg_0));
            map.from((Object)properties.isIgnoreMissingMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreMissingMigrations(arg_0));
            map.from((Object)properties.isIgnoreIgnoredMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreIgnoredMigrations(arg_0));
            map.from((Object)properties.isIgnorePendingMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignorePendingMigrations(arg_0));
            map.from((Object)properties.isIgnoreFutureMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreFutureMigrations(arg_0));
            map.from((Object)properties.isMixed()).to(arg_0 -> ((FluentConfiguration)configuration).mixed(arg_0));
            map.from((Object)properties.isOutOfOrder()).to(arg_0 -> ((FluentConfiguration)configuration).outOfOrder(arg_0));
            map.from((Object)properties.isSkipDefaultCallbacks()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultCallbacks(arg_0));
            map.from((Object)properties.isSkipDefaultResolvers()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultResolvers(arg_0));
            this.configureValidateMigrationNaming(configuration, properties.isValidateMigrationNaming());
            map.from((Object)properties.isValidateOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).validateOnMigrate(arg_0));
            map.from(properties.getInitSqls()).whenNot(CollectionUtils::isEmpty).as(initSqls -> StringUtils.collectionToDelimitedString((Collection)initSqls, (String)"\n")).to(arg_0 -> ((FluentConfiguration)configuration).initSql(arg_0));
            map.from((Object)properties.getBatch()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).batch(arg_0));
            map.from((Object)properties.getDryRunOutput()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).dryRunOutput(arg_0));
            map.from((Object)properties.getErrorOverrides()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).errorOverrides(arg_0));
            map.from((Object)properties.getLicenseKey()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).licenseKey(arg_0));
            map.from((Object)properties.getOracleSqlplus()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).oracleSqlplus(arg_0));
            map.from((Object)properties.getOracleSqlplusWarn()).whenNonNull().to(oracleSqlplusWarn -> configuration.oracleSqlplusWarn(oracleSqlplusWarn.booleanValue()));
            map.from((Object)properties.getStream()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).stream(arg_0));
            map.from((Object)properties.getUndoSqlMigrationPrefix()).whenNonNull().to(arg_0 -> ((FluentConfiguration)configuration).undoSqlMigrationPrefix(arg_0));
            map.from((Object)properties.getCherryPick()).whenNonNull().to(cherryPick -> configuration.cherryPick(cherryPick));
            map.from(properties.getJdbcProperties()).whenNot(Map::isEmpty).to(jdbcProperties -> configuration.jdbcProperties(jdbcProperties));
            map.from((Object)properties.getOracleKerberosCacheFile()).whenNonNull().to(cacheFile -> configuration.oracleKerberosCacheFile(cacheFile));
            map.from((Object)properties.getOracleKerberosConfigFile()).whenNonNull().to(configFile -> configuration.oracleKerberosConfigFile(configFile));
            map.from((Object)properties.getOutputQueryResults()).whenNonNull().to(outputQueryResults -> configuration.outputQueryResults(outputQueryResults.booleanValue()));
            map.from((Object)properties.getSkipExecutingMigrations()).whenNonNull().to(skipExecutingMigrations -> configuration.skipExecutingMigrations(skipExecutingMigrations.booleanValue()));
        }

        private void configureCreateSchemas(FluentConfiguration configuration, boolean createSchemas) {
            try {
                configuration.createSchemas(createSchemas);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        private void configureValidateMigrationNaming(FluentConfiguration configuration, boolean validateMigrationNaming) {
            try {
                configuration.validateMigrationNaming(validateMigrationNaming);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        private void configureCallbacks(FluentConfiguration configuration, List<Callback> callbacks) {
            if (!callbacks.isEmpty()) {
                configuration.callbacks(callbacks.toArray(new Callback[0]));
            }
        }

        private void configureFlywayCallbacks(FluentConfiguration flyway, List<Callback> callbacks) {
            if (!callbacks.isEmpty()) {
                flyway.callbacks(callbacks.toArray(new Callback[0]));
            }
        }

        private void configureJavaMigrations(FluentConfiguration flyway, List<JavaMigration> migrations) {
            if (!migrations.isEmpty()) {
                try {
                    flyway.javaMigrations(migrations.toArray(new JavaMigration[0]));
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }

        private String getProperty(Supplier<String> property, Supplier<String> defaultValue) {
            String value = property.get();
            return value != null ? value : defaultValue.get();
        }

        private boolean hasAtLeastOneLocation(ResourceLoader resourceLoader, Collection<String> locations) {
            for (String location : locations) {
                if (!resourceLoader.getResource(this.normalizePrefix(location)).exists()) continue;
                return true;
            }
            return false;
        }

        private String normalizePrefix(String location) {
            return location.replace("filesystem:", "file:");
        }

        @Bean
        @ConditionalOnMissingBean
        public FlywayMigrationInitializer flywayInitializer(Flyway flyway, ObjectProvider<FlywayMigrationStrategy> migrationStrategy) {
            return new FlywayMigrationInitializer(flyway, (FlywayMigrationStrategy)migrationStrategy.getIfAvailable());
        }
    }
}

