/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cassandra;

import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.data.cassandra")
public class CassandraProperties {
    private String keyspaceName;
    private String sessionName;
    private final List<String> contactPoints = new ArrayList<String>(Collections.singleton("127.0.0.1:9042"));
    private int port = 9042;
    private String localDatacenter;
    private String username;
    private String password;
    private Compression compression = Compression.NONE;
    private String schemaAction = "none";
    private boolean ssl = false;
    private final Connection connection = new Connection();
    private final Pool pool = new Pool();
    private final Request request = new Request();
    private final Controlconnection controlconnection = new Controlconnection();

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public List<String> getContactPoints() {
        return this.contactPoints;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getLocalDatacenter() {
        return this.localDatacenter;
    }

    public void setLocalDatacenter(String localDatacenter) {
        this.localDatacenter = localDatacenter;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getSchemaAction() {
        return this.schemaAction;
    }

    public void setSchemaAction(String schemaAction) {
        this.schemaAction = schemaAction;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Pool getPool() {
        return this.pool;
    }

    public Request getRequest() {
        return this.request;
    }

    public Controlconnection getControlconnection() {
        return this.controlconnection;
    }

    public static enum ThrottlerType {
        CONCURRENCY_LIMITING("ConcurrencyLimitingRequestThrottler"),
        RATE_LIMITING("RateLimitingRequestThrottler"),
        NONE("PassThroughRequestThrottler");

        private final String type;

        private ThrottlerType(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }
    }

    public static enum Compression {
        LZ4,
        SNAPPY,
        NONE;

    }

    public static class Throttler {
        private ThrottlerType type = ThrottlerType.NONE;
        private int maxQueueSize;
        private int maxConcurrentRequests;
        private int maxRequestsPerSecond;
        private Duration drainInterval;

        public ThrottlerType getType() {
            return this.type;
        }

        public void setType(ThrottlerType type) {
            this.type = type;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        public int getMaxConcurrentRequests() {
            return this.maxConcurrentRequests;
        }

        public void setMaxConcurrentRequests(int maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
        }

        public int getMaxRequestsPerSecond() {
            return this.maxRequestsPerSecond;
        }

        public void setMaxRequestsPerSecond(int maxRequestsPerSecond) {
            this.maxRequestsPerSecond = maxRequestsPerSecond;
        }

        public Duration getDrainInterval() {
            return this.drainInterval;
        }

        public void setDrainInterval(Duration drainInterval) {
            this.drainInterval = drainInterval;
        }
    }

    public static class Controlconnection {
        private Duration timeout = Duration.ofSeconds(5L);

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }
    }

    public static class Pool {
        private Duration idleTimeout = Duration.ofSeconds(5L);
        private Duration heartbeatInterval = Duration.ofSeconds(30L);

        public Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        public void setIdleTimeout(Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        public Duration getHeartbeatInterval() {
            return this.heartbeatInterval;
        }

        public void setHeartbeatInterval(Duration heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
        }
    }

    public static class Request {
        private Duration timeout = Duration.ofSeconds(2L);
        private DefaultConsistencyLevel consistency;
        private DefaultConsistencyLevel serialConsistency;
        private int pageSize = 5000;
        private final Throttler throttler = new Throttler();

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public DefaultConsistencyLevel getConsistency() {
            return this.consistency;
        }

        public void setConsistency(DefaultConsistencyLevel consistency) {
            this.consistency = consistency;
        }

        public DefaultConsistencyLevel getSerialConsistency() {
            return this.serialConsistency;
        }

        public void setSerialConsistency(DefaultConsistencyLevel serialConsistency) {
            this.serialConsistency = serialConsistency;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public Throttler getThrottler() {
            return this.throttler;
        }
    }

    public static class Connection {
        private Duration connectTimeout = Duration.ofSeconds(5L);
        private Duration initQueryTimeout = Duration.ofSeconds(5L);

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Duration getInitQueryTimeout() {
            return this.initQueryTimeout;
        }

        public void setInitQueryTimeout(Duration initQueryTimeout) {
            this.initQueryTimeout = initQueryTimeout;
        }
    }
}

