/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.saml2;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.core.io.Resource;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

@ConfigurationProperties(value="spring.security.saml2.relyingparty")
public class Saml2RelyingPartyProperties {
    private final Map<String, Registration> registration = new LinkedHashMap<String, Registration>();

    public Map<String, Registration> getRegistration() {
        return this.registration;
    }

    public static class Identityprovider {
        private String entityId;
        private String metadataUri;
        private final Singlesignon singlesignon = new Singlesignon();
        private final Verification verification = new Verification();

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public String getMetadataUri() {
            return this.metadataUri;
        }

        public void setMetadataUri(String metadataUri) {
            this.metadataUri = metadataUri;
        }

        @Deprecated
        @DeprecatedConfigurationProperty(reason="moved to 'singlesignon.url'")
        public String getSsoUrl() {
            return this.singlesignon.getUrl();
        }

        @Deprecated
        public void setSsoUrl(String ssoUrl) {
            this.singlesignon.setUrl(ssoUrl);
        }

        public Singlesignon getSinglesignon() {
            return this.singlesignon;
        }

        public Verification getVerification() {
            return this.verification;
        }

        public static class Verification {
            private List<Credential> credentials = new ArrayList<Credential>();

            public List<Credential> getCredentials() {
                return this.credentials;
            }

            public void setCredentials(List<Credential> credentials) {
                this.credentials = credentials;
            }

            public static class Credential {
                private Resource certificate;

                public Resource getCertificateLocation() {
                    return this.certificate;
                }

                public void setCertificateLocation(Resource certificate) {
                    this.certificate = certificate;
                }
            }
        }

        public static class Singlesignon {
            private String url;
            private Saml2MessageBinding binding = Saml2MessageBinding.REDIRECT;
            private boolean signRequest = true;

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public Saml2MessageBinding getBinding() {
                return this.binding;
            }

            public void setBinding(Saml2MessageBinding binding) {
                this.binding = binding;
            }

            public boolean isSignRequest() {
                return this.signRequest;
            }

            public void setSignRequest(boolean signRequest) {
                this.signRequest = signRequest;
            }
        }
    }

    public static class Registration {
        private String relyingPartyEntityId = "{baseUrl}/saml2/service-provider-metadata/{registrationId}";
        private final Signing signing = new Signing();
        private final Identityprovider identityprovider = new Identityprovider();

        public String getRelyingPartyEntityId() {
            return this.relyingPartyEntityId;
        }

        public void setRelyingPartyEntityId(String entityId) {
            this.relyingPartyEntityId = entityId;
        }

        public Signing getSigning() {
            return this.signing;
        }

        public Identityprovider getIdentityprovider() {
            return this.identityprovider;
        }

        public static class Signing {
            private List<Credential> credentials = new ArrayList<Credential>();

            public List<Credential> getCredentials() {
                return this.credentials;
            }

            public void setCredentials(List<Credential> credentials) {
                this.credentials = credentials;
            }

            public static class Credential {
                private Resource privateKeyLocation;
                private Resource certificateLocation;

                public Resource getPrivateKeyLocation() {
                    return this.privateKeyLocation;
                }

                public void setPrivateKeyLocation(Resource privateKey) {
                    this.privateKeyLocation = privateKey;
                }

                public Resource getCertificateLocation() {
                    return this.certificateLocation;
                }

                public void setCertificateLocation(Resource certificate) {
                    this.certificateLocation = certificate;
                }
            }
        }
    }
}

