/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource.servlet;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.oauth2.server.resource.introspection.NimbusOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.SecurityFilterChain;

@Configuration(proxyBeanMethods=false)
class OAuth2ResourceServerOpaqueTokenConfiguration {
    OAuth2ResourceServerOpaqueTokenConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SecurityFilterChain.class, WebSecurityConfigurerAdapter.class})
    @ConditionalOnMissingBean(value={WebSecurityConfigurerAdapter.class, SecurityFilterChain.class})
    static class OAuth2WebSecurityConfigurerAdapter {
        OAuth2WebSecurityConfigurerAdapter() {
        }

        @Bean
        @ConditionalOnBean(value={OpaqueTokenIntrospector.class})
        WebSecurityConfigurerAdapter opaqueTokenWebSecurityConfigurerAdapter() {
            return new WebSecurityConfigurerAdapter(){

                protected void configure(HttpSecurity http) throws Exception {
                    http.authorizeRequests(requests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated());
                    http.oauth2ResourceServer(OAuth2ResourceServerConfigurer::opaqueToken);
                }
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={OpaqueTokenIntrospector.class})
    static class OpaqueTokenIntrospectionClientConfiguration {
        OpaqueTokenIntrospectionClientConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.opaquetoken.introspection-uri"})
        NimbusOpaqueTokenIntrospector opaqueTokenIntrospector(OAuth2ResourceServerProperties properties) {
            OAuth2ResourceServerProperties.Opaquetoken opaqueToken = properties.getOpaquetoken();
            return new NimbusOpaqueTokenIntrospector(opaqueToken.getIntrospectionUri(), opaqueToken.getClientId(), opaqueToken.getClientSecret());
        }
    }
}

