/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cassandra;

import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(prefix="spring.data.cassandra")
public class CassandraProperties {
    private String keyspaceName;
    private String sessionName;
    private final List<String> contactPoints = new ArrayList<String>(Collections.singleton("127.0.0.1:9042"));
    private int port = 9042;
    private String localDatacenter;
    private String username;
    private String password;
    private Compression compression = Compression.NONE;
    private DefaultConsistencyLevel consistencyLevel;
    private DefaultConsistencyLevel serialConsistencyLevel;
    private int pageSize = 5000;
    private Duration connectTimeout;
    private Duration readTimeout;
    private String schemaAction = "none";
    private boolean ssl = false;
    private final Pool pool = new Pool();

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.data.cassandra.session-name")
    public String getClusterName() {
        return this.getSessionName();
    }

    @Deprecated
    public void setClusterName(String clusterName) {
        this.setSessionName(clusterName);
    }

    public List<String> getContactPoints() {
        return this.contactPoints;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getLocalDatacenter() {
        return this.localDatacenter;
    }

    public void setLocalDatacenter(String localDatacenter) {
        this.localDatacenter = localDatacenter;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public DefaultConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(DefaultConsistencyLevel consistency) {
        this.consistencyLevel = consistency;
    }

    public DefaultConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistencyLevel;
    }

    public void setSerialConsistencyLevel(DefaultConsistencyLevel serialConsistency) {
        this.serialConsistencyLevel = serialConsistency;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="spring.data.cassandra.page-size")
    public int getFetchSize() {
        return this.getPageSize();
    }

    @Deprecated
    public void setFetchSize(int fetchSize) {
        this.setPageSize(fetchSize);
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getSchemaAction() {
        return this.schemaAction;
    }

    public void setSchemaAction(String schemaAction) {
        this.schemaAction = schemaAction;
    }

    public Pool getPool() {
        return this.pool;
    }

    public static enum Compression {
        LZ4,
        SNAPPY,
        NONE;

    }

    public static class Pool {
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration idleTimeout = Duration.ofSeconds(120L);
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration heartbeatInterval = Duration.ofSeconds(30L);
        private int maxQueueSize = 256;

        public Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        public void setIdleTimeout(Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        public Duration getHeartbeatInterval() {
            return this.heartbeatInterval;
        }

        public void setHeartbeatInterval(Duration heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }
    }
}

