/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultProgrammaticDriverConfigLoaderBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.cassandra.CassandraProperties;
import org.springframework.boot.autoconfigure.cassandra.CqlSessionBuilderCustomizer;
import org.springframework.boot.autoconfigure.cassandra.DriverConfigLoaderBuilderCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CqlSession.class})
@EnableConfigurationProperties(value={CassandraProperties.class})
public class CassandraAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Lazy
    public CqlSession cassandraSession(CqlSessionBuilder cqlSessionBuilder) {
        return (CqlSession)cqlSessionBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public CqlSessionBuilder cassandraSessionBuilder(CassandraProperties properties, DriverConfigLoader driverConfigLoader, ObjectProvider<CqlSessionBuilderCustomizer> builderCustomizers) {
        CqlSessionBuilder builder = (CqlSessionBuilder)CqlSession.builder().withConfigLoader(driverConfigLoader);
        this.configureSsl(properties, builder);
        builder.withKeyspace(properties.getKeyspaceName());
        builderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    private void configureSsl(CassandraProperties properties, CqlSessionBuilder builder) {
        if (properties.isSsl()) {
            try {
                builder.withSslContext(SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException("Could not setup SSL default context for Cassandra", ex);
            }
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public DriverConfigLoader cassandraDriverConfigLoader(CassandraProperties properties, ObjectProvider<DriverConfigLoaderBuilderCustomizer> builderCustomizers) {
        DefaultProgrammaticDriverConfigLoaderBuilder builder = new DefaultProgrammaticDriverConfigLoaderBuilder(() -> this.cassandraConfiguration(properties), "datastax-java-driver");
        builderCustomizers.orderedStream().forEach(arg_0 -> CassandraAutoConfiguration.lambda$cassandraDriverConfigLoader$2((ProgrammaticDriverConfigLoaderBuilder)builder, arg_0));
        return builder.build();
    }

    private Config cassandraConfiguration(CassandraProperties properties) {
        CassandraDriverOptions options = new CassandraDriverOptions();
        PropertyMapper map = PropertyMapper.get();
        map.from((Object)properties.getSessionName()).whenHasText().to(sessionName -> options.add((DriverOption)DefaultDriverOption.SESSION_NAME, sessionName));
        map.from(properties::getUsername).whenNonNull().to(username -> options.add((DriverOption)DefaultDriverOption.AUTH_PROVIDER_USER_NAME, username).add((DriverOption)DefaultDriverOption.AUTH_PROVIDER_PASSWORD, properties.getPassword()));
        map.from(properties::getCompression).whenNonNull().to(compression -> options.add((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, compression));
        this.mapQueryOptions(properties, options);
        this.mapSocketOptions(properties, options);
        this.mapPoolingOptions(properties, options);
        map.from(this.mapContactPoints(properties)).to(contactPoints -> options.add((DriverOption)DefaultDriverOption.CONTACT_POINTS, contactPoints));
        map.from((Object)properties.getLocalDatacenter()).to(localDatacenter -> options.add((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, localDatacenter));
        ConfigFactory.invalidateCaches();
        return ConfigFactory.defaultOverrides().withFallback((ConfigMergeable)options.build()).withFallback((ConfigMergeable)ConfigFactory.defaultReference()).resolve();
    }

    private void mapQueryOptions(CassandraProperties properties, CassandraDriverOptions options) {
        PropertyMapper map = PropertyMapper.get();
        map.from(properties::getConsistencyLevel).whenNonNull().to(consistency -> options.add((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, (Enum)consistency));
        map.from(properties::getSerialConsistencyLevel).whenNonNull().to(serialConsistency -> options.add((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY, (Enum)serialConsistency));
        map.from(properties::getPageSize).to(pageSize -> options.add((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, pageSize));
    }

    private void mapSocketOptions(CassandraProperties properties, CassandraDriverOptions options) {
        PropertyMapper map = PropertyMapper.get();
        map.from(properties::getConnectTimeout).whenNonNull().asInt(Duration::toMillis).to(connectTimeout -> options.add((DriverOption)DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, connectTimeout));
        map.from(properties::getReadTimeout).whenNonNull().asInt(Duration::toMillis).to(readTimeout -> options.add((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, readTimeout));
    }

    private void mapPoolingOptions(CassandraProperties properties, CassandraDriverOptions options) {
        PropertyMapper map = PropertyMapper.get();
        CassandraProperties.Pool poolProperties = properties.getPool();
        map.from(poolProperties::getIdleTimeout).whenNonNull().asInt(Duration::getSeconds).to(idleTimeout -> options.add((DriverOption)DefaultDriverOption.HEARTBEAT_TIMEOUT, idleTimeout));
        map.from(poolProperties::getHeartbeatInterval).whenNonNull().asInt(Duration::getSeconds).to(heartBeatInterval -> options.add((DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL, heartBeatInterval));
        map.from(poolProperties::getMaxQueueSize).to(maxQueueSize -> options.add((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_QUEUE_SIZE, maxQueueSize));
    }

    private List<String> mapContactPoints(CassandraProperties properties) {
        return properties.getContactPoints().stream().map(candidate -> this.formatContactPoint((String)candidate, properties.getPort())).collect(Collectors.toList());
    }

    private String formatContactPoint(String candidate, int port) {
        int i = candidate.lastIndexOf(58);
        if (i == -1 || !this.isPort(() -> candidate.substring(i + 1))) {
            return String.format("%s:%s", candidate, port);
        }
        return candidate;
    }

    private boolean isPort(Supplier<String> value) {
        try {
            int i = Integer.parseInt(value.get());
            return i > 0 && i < 65535;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static /* synthetic */ void lambda$cassandraDriverConfigLoader$2(ProgrammaticDriverConfigLoaderBuilder builder, DriverConfigLoaderBuilderCustomizer customizer) {
        customizer.customize(builder);
    }

    private static class CassandraDriverOptions {
        private final Map<String, String> options = new LinkedHashMap<String, String>();

        private CassandraDriverOptions() {
        }

        private CassandraDriverOptions add(DriverOption option, String value) {
            String key = CassandraDriverOptions.createKeyFor(option);
            this.options.put(key, value);
            return this;
        }

        private CassandraDriverOptions add(DriverOption option, int value) {
            return this.add(option, String.valueOf(value));
        }

        private CassandraDriverOptions add(DriverOption option, Enum<?> value) {
            return this.add(option, value.name());
        }

        private CassandraDriverOptions add(DriverOption option, List<String> values) {
            for (int i = 0; i < values.size(); ++i) {
                this.options.put(String.format("%s.%s", CassandraDriverOptions.createKeyFor(option), i), values.get(i));
            }
            return this;
        }

        private Config build() {
            return ConfigFactory.parseMap(this.options, (String)"Environment");
        }

        private static String createKeyFor(DriverOption option) {
            return String.format("%s.%s", "datastax-java-driver", option.getPath());
        }
    }
}

