/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import java.time.Duration;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.session.JdbcSessionDataSourceInitializer;
import org.springframework.boot.autoconfigure.session.JdbcSessionProperties;
import org.springframework.boot.autoconfigure.session.ServletSessionCondition;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.session.SessionRepository;
import org.springframework.session.jdbc.JdbcOperationsSessionRepository;
import org.springframework.session.jdbc.config.annotation.web.http.JdbcHttpSessionConfiguration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JdbcTemplate.class, JdbcOperationsSessionRepository.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={DataSource.class})
@Conditional(value={ServletSessionCondition.class})
@EnableConfigurationProperties(value={JdbcSessionProperties.class})
class JdbcSessionConfiguration {
    JdbcSessionConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    JdbcSessionDataSourceInitializer jdbcSessionDataSourceInitializer(DataSource dataSource, ResourceLoader resourceLoader, JdbcSessionProperties properties) {
        return new JdbcSessionDataSourceInitializer(dataSource, resourceLoader, properties);
    }

    @Configuration
    static class SpringBootJdbcHttpSessionConfiguration
    extends JdbcHttpSessionConfiguration {
        SpringBootJdbcHttpSessionConfiguration() {
        }

        @Autowired
        void customize(SessionProperties sessionProperties, JdbcSessionProperties jdbcSessionProperties) {
            Duration timeout = sessionProperties.getTimeout();
            if (timeout != null) {
                this.setMaxInactiveIntervalInSeconds((int)timeout.getSeconds());
            }
            this.setTableName(jdbcSessionProperties.getTableName());
            this.setCleanupCron(jdbcSessionProperties.getCleanupCron());
            this.setFlushMode(jdbcSessionProperties.getFlushMode());
            this.setSaveMode(jdbcSessionProperties.getSaveMode());
        }
    }
}

