/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.liquibase;

import java.util.function.Supplier;
import javax.sql.DataSource;
import liquibase.change.DatabaseChange;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcOperationsDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.NamedParameterJdbcOperationsDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.liquibase.DataSourceClosingSpringLiquibase;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseDataSource;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseSchemaManagementProvider;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SpringLiquibase.class, DatabaseChange.class})
@ConditionalOnProperty(prefix="spring.liquibase", name={"enabled"}, matchIfMissing=true)
@Conditional(value={LiquibaseDataSourceCondition.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class LiquibaseAutoConfiguration {
    @Bean
    public LiquibaseSchemaManagementProvider liquibaseDefaultDdlModeProvider(ObjectProvider<SpringLiquibase> liquibases) {
        return new LiquibaseSchemaManagementProvider(liquibases);
    }

    static final class LiquibaseDataSourceCondition
    extends AnyNestedCondition {
        LiquibaseDataSourceCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="spring.liquibase", name={"url"}, matchIfMissing=false)
        private static final class LiquibaseUrlCondition {
            private LiquibaseUrlCondition() {
            }
        }

        @ConditionalOnBean(value={DataSource.class})
        private static final class DataSourceBeanCondition {
            private DataSourceBeanCondition() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={NamedParameterJdbcOperations.class})
    @ConditionalOnBean(value={NamedParameterJdbcOperations.class})
    protected static class LiquibaseNamedParameterJdbcOperationsDependencyConfiguration
    extends NamedParameterJdbcOperationsDependsOnPostProcessor {
        public LiquibaseNamedParameterJdbcOperationsDependencyConfiguration() {
            super(SpringLiquibase.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JdbcOperations.class})
    @ConditionalOnBean(value={JdbcOperations.class})
    protected static class LiquibaseJdbcOperationsDependencyConfiguration
    extends JdbcOperationsDependsOnPostProcessor {
        public LiquibaseJdbcOperationsDependencyConfiguration() {
            super(SpringLiquibase.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    protected static class LiquibaseJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        public LiquibaseJpaDependencyConfiguration() {
            super(SpringLiquibase.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={SpringLiquibase.class})
    @EnableConfigurationProperties(value={DataSourceProperties.class, LiquibaseProperties.class})
    @Import(value={LiquibaseJpaDependencyConfiguration.class})
    public static class LiquibaseConfiguration {
        private final LiquibaseProperties properties;

        public LiquibaseConfiguration(LiquibaseProperties properties) {
            this.properties = properties;
        }

        @Bean
        public SpringLiquibase liquibase(DataSourceProperties dataSourceProperties, ObjectProvider<DataSource> dataSource, @LiquibaseDataSource ObjectProvider<DataSource> liquibaseDataSource) {
            SpringLiquibase liquibase = this.createSpringLiquibase((DataSource)liquibaseDataSource.getIfAvailable(), (DataSource)dataSource.getIfUnique(), dataSourceProperties);
            liquibase.setChangeLog(this.properties.getChangeLog());
            liquibase.setContexts(this.properties.getContexts());
            liquibase.setDefaultSchema(this.properties.getDefaultSchema());
            liquibase.setLiquibaseSchema(this.properties.getLiquibaseSchema());
            liquibase.setLiquibaseTablespace(this.properties.getLiquibaseTablespace());
            liquibase.setDatabaseChangeLogTable(this.properties.getDatabaseChangeLogTable());
            liquibase.setDatabaseChangeLogLockTable(this.properties.getDatabaseChangeLogLockTable());
            liquibase.setDropFirst(this.properties.isDropFirst());
            liquibase.setShouldRun(this.properties.isEnabled());
            liquibase.setLabels(this.properties.getLabels());
            liquibase.setChangeLogParameters(this.properties.getParameters());
            liquibase.setRollbackFile(this.properties.getRollbackFile());
            liquibase.setTestRollbackOnUpdate(this.properties.isTestRollbackOnUpdate());
            return liquibase;
        }

        private SpringLiquibase createSpringLiquibase(DataSource liquibaseDatasource, DataSource dataSource, DataSourceProperties dataSourceProperties) {
            DataSource liquibaseDataSource = this.getDataSource(liquibaseDatasource, dataSource);
            if (liquibaseDataSource != null) {
                SpringLiquibase liquibase = new SpringLiquibase();
                liquibase.setDataSource(liquibaseDataSource);
                return liquibase;
            }
            DataSourceClosingSpringLiquibase liquibase = new DataSourceClosingSpringLiquibase();
            liquibase.setDataSource(this.createNewDataSource(dataSourceProperties));
            return liquibase;
        }

        private DataSource getDataSource(DataSource liquibaseDataSource, DataSource dataSource) {
            if (liquibaseDataSource != null) {
                return liquibaseDataSource;
            }
            if (this.properties.getUrl() == null && this.properties.getUser() == null) {
                return dataSource;
            }
            return null;
        }

        private DataSource createNewDataSource(DataSourceProperties dataSourceProperties) {
            String url = this.getProperty(this.properties::getUrl, dataSourceProperties::determineUrl);
            String user = this.getProperty(this.properties::getUser, dataSourceProperties::determineUsername);
            String password = this.getProperty(this.properties::getPassword, dataSourceProperties::determinePassword);
            return DataSourceBuilder.create().url(url).username(user).password(password).build();
        }

        private String getProperty(Supplier<String> property, Supplier<String> defaultValue) {
            String value = property.get();
            return value != null ? value : defaultValue.get();
        }
    }
}

