/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.servlet;

import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.servlet.JerseyRequestMatcherProvider;
import org.springframework.boot.autoconfigure.security.servlet.MvcRequestMatcherProvider;
import org.springframework.boot.autoconfigure.security.servlet.RequestMatcherProvider;
import org.springframework.boot.autoconfigure.web.servlet.JerseyApplicationPath;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RequestMatcher.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class SecurityRequestMatcherProviderAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ResourceConfig.class})
    @ConditionalOnMissingClass(value={"org.springframework.web.servlet.DispatcherServlet"})
    @ConditionalOnBean(value={JerseyApplicationPath.class})
    public static class JerseyRequestMatcherConfiguration {
        @Bean
        public RequestMatcherProvider requestMatcherProvider(JerseyApplicationPath applicationPath) {
            return new JerseyRequestMatcherProvider(applicationPath);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={DispatcherServlet.class})
    @ConditionalOnBean(value={HandlerMappingIntrospector.class})
    public static class MvcRequestMatcherConfiguration {
        @Bean
        @ConditionalOnClass(value={DispatcherServlet.class})
        public RequestMatcherProvider requestMatcherProvider(HandlerMappingIntrospector introspector) {
            return new MvcRequestMatcherProvider(introspector);
        }
    }
}

