/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource.reactive;

import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.IssuerUriCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.KeyValueCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoders;

@Configuration(proxyBeanMethods=false)
class ReactiveOAuth2ResourceServerJwkConfiguration {
    private final OAuth2ResourceServerProperties.Jwt properties;

    ReactiveOAuth2ResourceServerJwkConfiguration(OAuth2ResourceServerProperties properties) {
        this.properties = properties.getJwt();
    }

    @Bean
    @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.jwt.jwk-set-uri"})
    @ConditionalOnMissingBean
    public ReactiveJwtDecoder jwtDecoder() {
        return new NimbusReactiveJwtDecoder(this.properties.getJwkSetUri());
    }

    @Bean
    @Conditional(value={KeyValueCondition.class})
    @ConditionalOnMissingBean
    public NimbusReactiveJwtDecoder jwtDecoderByPublicKeyValue() throws Exception {
        RSAPublicKey publicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(this.getKeySpec(this.properties.readPublicKey())));
        return NimbusReactiveJwtDecoder.withPublicKey((RSAPublicKey)publicKey).build();
    }

    private byte[] getKeySpec(String keyValue) {
        keyValue = keyValue.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replace("\n", "");
        return Base64.getDecoder().decode(keyValue);
    }

    @Bean
    @Conditional(value={IssuerUriCondition.class})
    @ConditionalOnMissingBean
    public ReactiveJwtDecoder jwtDecoderByIssuerUri() {
        return ReactiveJwtDecoders.fromOidcIssuerLocation((String)this.properties.getIssuerUri());
    }
}

