/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.rsocket;

import io.rsocket.RSocketFactory;
import io.rsocket.SocketAcceptor;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.server.WebsocketRouteTransport;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.messaging.rsocket.MessageHandlerAcceptor;
import reactor.netty.http.server.HttpServer;

class RSocketNettyServerCustomizer
implements NettyServerCustomizer {
    private final String mappingPath;
    private final MessageHandlerAcceptor messageHandlerAcceptor;

    RSocketNettyServerCustomizer(String mappingPath, MessageHandlerAcceptor messageHandlerAcceptor) {
        this.mappingPath = mappingPath;
        this.messageHandlerAcceptor = messageHandlerAcceptor;
    }

    public HttpServer apply(HttpServer httpServer) {
        ServerTransport.ConnectionAcceptor acceptor = RSocketFactory.receive().acceptor((SocketAcceptor)this.messageHandlerAcceptor).toConnectionAcceptor();
        return httpServer.route(routes -> routes.ws(this.mappingPath, WebsocketRouteTransport.newHandler((ServerTransport.ConnectionAcceptor)acceptor)));
    }
}

