/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.activemq;

import java.util.List;
import java.util.stream.Collectors;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.pool2.PooledObject;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryFactory;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQConnectionFactoryCustomizer;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQConnectionFactoryFactory;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={ConnectionFactory.class})
class ActiveMQConnectionFactoryConfiguration {
    ActiveMQConnectionFactoryConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JmsPoolConnectionFactory.class, PooledObject.class})
    static class PooledConnectionFactoryConfiguration {
        PooledConnectionFactoryConfiguration() {
        }

        @Bean(destroyMethod="stop")
        @ConditionalOnProperty(prefix="spring.activemq.pool", name={"enabled"}, havingValue="true", matchIfMissing=false)
        public JmsPoolConnectionFactory pooledJmsConnectionFactory(ActiveMQProperties properties, ObjectProvider<ActiveMQConnectionFactoryCustomizer> factoryCustomizers) {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactoryFactory(properties, factoryCustomizers.orderedStream().collect(Collectors.toList())).createConnectionFactory(ActiveMQConnectionFactory.class);
            return new JmsPoolConnectionFactoryFactory(properties.getPool()).createPooledConnectionFactory((ConnectionFactory)connectionFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CachingConnectionFactory.class})
    @ConditionalOnProperty(prefix="spring.activemq.pool", name={"enabled"}, havingValue="false", matchIfMissing=true)
    static class SimpleConnectionFactoryConfiguration {
        private final ActiveMQProperties properties;
        private final List<ActiveMQConnectionFactoryCustomizer> connectionFactoryCustomizers;

        SimpleConnectionFactoryConfiguration(ActiveMQProperties properties, ObjectProvider<ActiveMQConnectionFactoryCustomizer> connectionFactoryCustomizers) {
            this.properties = properties;
            this.connectionFactoryCustomizers = connectionFactoryCustomizers.orderedStream().collect(Collectors.toList());
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public CachingConnectionFactory cachingJmsConnectionFactory(JmsProperties jmsProperties) {
            JmsProperties.Cache cacheProperties = jmsProperties.getCache();
            CachingConnectionFactory connectionFactory = new CachingConnectionFactory((ConnectionFactory)this.createConnectionFactory());
            connectionFactory.setCacheConsumers(cacheProperties.isConsumers());
            connectionFactory.setCacheProducers(cacheProperties.isProducers());
            connectionFactory.setSessionCacheSize(cacheProperties.getSessionCacheSize());
            return connectionFactory;
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="false")
        public ActiveMQConnectionFactory jmsConnectionFactory() {
            return this.createConnectionFactory();
        }

        private ActiveMQConnectionFactory createConnectionFactory() {
            return new ActiveMQConnectionFactoryFactory(this.properties, this.connectionFactoryCustomizers).createConnectionFactory(ActiveMQConnectionFactory.class);
        }
    }
}

