/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastConfigResourceCondition;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastInstanceFactory;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={HazelcastInstance.class})
class HazelcastServerConfiguration {
    static final String CONFIG_SYSTEM_PROPERTY = "hazelcast.config";

    HazelcastServerConfiguration() {
    }

    static class ConfigAvailableCondition
    extends HazelcastConfigResourceCondition {
        ConfigAvailableCondition() {
            super(HazelcastServerConfiguration.CONFIG_SYSTEM_PROPERTY, new String[]{"file:./hazelcast.xml", "classpath:/hazelcast.xml"});
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSingleCandidate(value=Config.class)
    static class HazelcastServerConfigConfiguration {
        HazelcastServerConfigConfiguration() {
        }

        @Bean
        public HazelcastInstance hazelcastInstance(Config config) {
            return new HazelcastInstanceFactory(config).getHazelcastInstance();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={Config.class})
    @Conditional(value={ConfigAvailableCondition.class})
    static class HazelcastServerConfigFileConfiguration {
        HazelcastServerConfigFileConfiguration() {
        }

        @Bean
        public HazelcastInstance hazelcastInstance(HazelcastProperties properties) throws IOException {
            Resource config = properties.resolveConfigLocation();
            if (config != null) {
                return new HazelcastInstanceFactory(config).getHazelcastInstance();
            }
            return Hazelcast.newHazelcastInstance();
        }
    }
}

