/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.jpa;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfigureRegistrar;
import org.springframework.boot.autoconfigure.orm.jpa.EntityManagerFactoryBuilderCustomizer;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.config.JpaRepositoryConfigExtension;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnClass(value={JpaRepository.class})
@ConditionalOnMissingBean(value={JpaRepositoryFactoryBean.class, JpaRepositoryConfigExtension.class})
@ConditionalOnProperty(prefix="spring.data.jpa.repositories", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={JpaRepositoriesAutoConfigureRegistrar.class})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class, TaskExecutionAutoConfiguration.class})
public class JpaRepositoriesAutoConfiguration {
    @Bean
    @Conditional(value={BootstrapExecutorCondition.class})
    public EntityManagerFactoryBuilderCustomizer entityManagerFactoryBootstrapExecutorCustomizer(Map<String, AsyncTaskExecutor> taskExecutors) {
        return builder -> {
            AsyncTaskExecutor bootstrapExecutor = this.determineBootstrapExecutor(taskExecutors);
            if (bootstrapExecutor != null) {
                builder.setBootstrapExecutor(bootstrapExecutor);
            }
        };
    }

    private AsyncTaskExecutor determineBootstrapExecutor(Map<String, AsyncTaskExecutor> taskExecutors) {
        if (taskExecutors.size() == 1) {
            return taskExecutors.values().iterator().next();
        }
        return taskExecutors.get("applicationTaskExecutor");
    }

    private static final class BootstrapExecutorCondition
    extends AnyNestedCondition {
        BootstrapExecutorCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="spring.data.jpa.repositories", name={"bootstrap-mode"}, havingValue="lazy", matchIfMissing=false)
        static class LazyBootstrapMode {
            LazyBootstrapMode() {
            }
        }

        @ConditionalOnProperty(prefix="spring.data.jpa.repositories", name={"bootstrap-mode"}, havingValue="deferred", matchIfMissing=false)
        static class DeferredBootstrapMode {
            DeferredBootstrapMode() {
            }
        }
    }
}

