/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.couchbase;

import com.couchbase.client.java.env.CouchbaseEnvironment;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseConfiguration;
import org.springframework.boot.autoconfigure.data.couchbase.SpringBootCouchbaseConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.couchbase.config.CouchbaseConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CouchbaseConfigurer.class})
@ConditionalOnBean(value={CouchbaseConfiguration.class})
class CouchbaseConfigurerAdapterConfiguration {
    private final CouchbaseConfiguration configuration;

    CouchbaseConfigurerAdapterConfiguration(CouchbaseConfiguration configuration) {
        this.configuration = configuration;
    }

    @Bean
    @ConditionalOnMissingBean
    public CouchbaseConfigurer springBootCouchbaseConfigurer() throws Exception {
        return new SpringBootCouchbaseConfigurer((CouchbaseEnvironment)this.configuration.couchbaseEnvironment(), this.configuration.couchbaseCluster(), this.configuration.couchbaseClusterInfo(), this.configuration.couchbaseClient());
    }
}

