/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.thymeleaf;

import com.github.mxab.thymeleaf.extras.dataattribute.dialect.DataAttributeDialect;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.annotation.PostConstruct;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.MimeType;
import org.springframework.web.servlet.resource.ResourceUrlEncodingFilter;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;
import org.thymeleaf.extras.springsecurity4.dialect.SpringSecurityDialect;
import org.thymeleaf.spring5.ISpringTemplateEngine;
import org.thymeleaf.spring5.ISpringWebFluxTemplateEngine;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.SpringWebFluxTemplateEngine;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;
import org.thymeleaf.spring5.view.reactive.ThymeleafReactiveViewResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
@EnableConfigurationProperties(value={ThymeleafProperties.class})
@ConditionalOnClass(value={TemplateMode.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class, WebFluxAutoConfiguration.class})
public class ThymeleafAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Java8TimeDialect.class})
    protected static class ThymeleafJava8TimeDialect {
        protected ThymeleafJava8TimeDialect() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Java8TimeDialect java8TimeDialect() {
            return new Java8TimeDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={org.thymeleaf.extras.springsecurity5.dialect.SpringSecurityDialect.class})
    protected static class ThymeleafSecurity5DialectConfiguration {
        protected ThymeleafSecurity5DialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public org.thymeleaf.extras.springsecurity5.dialect.SpringSecurityDialect securityDialect() {
            return new org.thymeleaf.extras.springsecurity5.dialect.SpringSecurityDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={SpringSecurityDialect.class})
    protected static class ThymeleafSecurityDialectConfiguration {
        private final Log logger = LogFactory.getLog(ThymeleafSecurityDialectConfiguration.class);

        protected ThymeleafSecurityDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public SpringSecurityDialect securityDialect() {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Auto-configuration for thymeleaf-extras-springsecurity4 is deprecated in favour of thymeleaf-extras-springsecurity5");
            }
            return new SpringSecurityDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={DataAttributeDialect.class})
    protected static class DataAttributeDialectConfiguration {
        protected DataAttributeDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DataAttributeDialect dialect() {
            return new DataAttributeDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"nz.net.ultraq.thymeleaf.LayoutDialect"})
    protected static class ThymeleafWebLayoutConfiguration {
        protected ThymeleafWebLayoutConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public LayoutDialect layoutDialect() {
            return new LayoutDialect();
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnProperty(name={"spring.thymeleaf.enabled"}, matchIfMissing=true)
    static class ThymeleafWebFluxConfiguration {
        private final ThymeleafProperties properties;

        ThymeleafWebFluxConfiguration(ThymeleafProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean(name={"thymeleafReactiveViewResolver"})
        public ThymeleafReactiveViewResolver thymeleafViewResolver(ISpringWebFluxTemplateEngine templateEngine) {
            ThymeleafReactiveViewResolver resolver = new ThymeleafReactiveViewResolver();
            resolver.setTemplateEngine(templateEngine);
            this.mapProperties(this.properties, resolver);
            this.mapReactiveProperties(this.properties.getReactive(), resolver);
            resolver.setOrder(0x7FFFFFFA);
            return resolver;
        }

        private void mapProperties(ThymeleafProperties properties, ThymeleafReactiveViewResolver resolver) {
            PropertyMapper map = PropertyMapper.get();
            map.from(properties::getEncoding).to(arg_0 -> ((ThymeleafReactiveViewResolver)resolver).setDefaultCharset(arg_0));
            resolver.setExcludedViewNames(properties.getExcludedViewNames());
            resolver.setViewNames(properties.getViewNames());
        }

        private void mapReactiveProperties(ThymeleafProperties.Reactive properties, ThymeleafReactiveViewResolver resolver) {
            PropertyMapper map = PropertyMapper.get();
            map.from(properties::getMediaTypes).whenNonNull().to(arg_0 -> ((ThymeleafReactiveViewResolver)resolver).setSupportedMediaTypes(arg_0));
            map.from(properties::getMaxChunkSize).when(size -> size > 0).to(arg_0 -> ((ThymeleafReactiveViewResolver)resolver).setResponseMaxChunkSizeBytes(arg_0));
            map.from(properties::getFullModeViewNames).to(arg_0 -> ((ThymeleafReactiveViewResolver)resolver).setFullModeViewNames(arg_0));
            map.from(properties::getChunkedModeViewNames).to(arg_0 -> ((ThymeleafReactiveViewResolver)resolver).setChunkedModeViewNames(arg_0));
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnProperty(name={"spring.thymeleaf.enabled"}, matchIfMissing=true)
    static class ThymeleafReactiveConfiguration {
        private final ThymeleafProperties properties;
        private final Collection<ITemplateResolver> templateResolvers;
        private final Collection<IDialect> dialects;

        ThymeleafReactiveConfiguration(ThymeleafProperties properties, Collection<ITemplateResolver> templateResolvers, ObjectProvider<Collection<IDialect>> dialectsProvider) {
            this.properties = properties;
            this.templateResolvers = templateResolvers;
            this.dialects = (Collection)dialectsProvider.getIfAvailable(Collections::emptyList);
        }

        @Bean
        @ConditionalOnMissingBean(value={ISpringWebFluxTemplateEngine.class})
        public SpringWebFluxTemplateEngine templateEngine() {
            SpringWebFluxTemplateEngine engine = new SpringWebFluxTemplateEngine();
            engine.setEnableSpringELCompiler(this.properties.isEnableSpringElCompiler());
            this.templateResolvers.forEach(arg_0 -> ((SpringWebFluxTemplateEngine)engine).addTemplateResolver(arg_0));
            this.dialects.forEach(arg_0 -> ((SpringWebFluxTemplateEngine)engine).addDialect(arg_0));
            return engine;
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnProperty(name={"spring.thymeleaf.enabled"}, matchIfMissing=true)
    static class ThymeleafWebMvcConfiguration {
        ThymeleafWebMvcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ResourceUrlEncodingFilter.class})
        @ConditionalOnEnabledResourceChain
        public FilterRegistrationBean<ResourceUrlEncodingFilter> resourceUrlEncodingFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean((Filter)new ResourceUrlEncodingFilter(), new ServletRegistrationBean[0]);
            registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ERROR});
            return registration;
        }

        @Configuration
        static class ThymeleafViewResolverConfiguration {
            private final ThymeleafProperties properties;
            private final SpringTemplateEngine templateEngine;

            ThymeleafViewResolverConfiguration(ThymeleafProperties properties, SpringTemplateEngine templateEngine) {
                this.properties = properties;
                this.templateEngine = templateEngine;
            }

            @Bean
            @ConditionalOnMissingBean(name={"thymeleafViewResolver"})
            public ThymeleafViewResolver thymeleafViewResolver() {
                ThymeleafViewResolver resolver = new ThymeleafViewResolver();
                resolver.setTemplateEngine((ISpringTemplateEngine)this.templateEngine);
                resolver.setCharacterEncoding(this.properties.getEncoding().name());
                resolver.setContentType(this.appendCharset(this.properties.getServlet().getContentType(), resolver.getCharacterEncoding()));
                resolver.setExcludedViewNames(this.properties.getExcludedViewNames());
                resolver.setViewNames(this.properties.getViewNames());
                resolver.setOrder(0x7FFFFFFA);
                resolver.setCache(this.properties.isCache());
                return resolver;
            }

            private String appendCharset(MimeType type, String charset) {
                if (type.getCharset() != null) {
                    return type.toString();
                }
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                parameters.put("charset", charset);
                parameters.putAll(type.getParameters());
                return new MimeType(type, parameters).toString();
            }
        }
    }

    @Configuration
    protected static class ThymeleafDefaultConfiguration {
        private final ThymeleafProperties properties;
        private final Collection<ITemplateResolver> templateResolvers;
        private final Collection<IDialect> dialects;

        public ThymeleafDefaultConfiguration(ThymeleafProperties properties, Collection<ITemplateResolver> templateResolvers, ObjectProvider<Collection<IDialect>> dialectsProvider) {
            this.properties = properties;
            this.templateResolvers = templateResolvers;
            this.dialects = (Collection)dialectsProvider.getIfAvailable(Collections::emptyList);
        }

        @Bean
        @ConditionalOnMissingBean
        public SpringTemplateEngine templateEngine() {
            SpringTemplateEngine engine = new SpringTemplateEngine();
            engine.setEnableSpringELCompiler(this.properties.isEnableSpringElCompiler());
            this.templateResolvers.forEach(arg_0 -> ((SpringTemplateEngine)engine).addTemplateResolver(arg_0));
            this.dialects.forEach(arg_0 -> ((SpringTemplateEngine)engine).addDialect(arg_0));
            return engine;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(name={"defaultTemplateResolver"})
    static class DefaultTemplateResolverConfiguration {
        private static final Log logger = LogFactory.getLog(DefaultTemplateResolverConfiguration.class);
        private final ThymeleafProperties properties;
        private final ApplicationContext applicationContext;

        DefaultTemplateResolverConfiguration(ThymeleafProperties properties, ApplicationContext applicationContext) {
            this.properties = properties;
            this.applicationContext = applicationContext;
        }

        @PostConstruct
        public void checkTemplateLocationExists() {
            TemplateLocation location;
            boolean checkTemplateLocation = this.properties.isCheckTemplateLocation();
            if (checkTemplateLocation && !(location = new TemplateLocation(this.properties.getPrefix())).exists((ResourcePatternResolver)this.applicationContext)) {
                logger.warn((Object)("Cannot find template location: " + location + " (please add some templates or check your Thymeleaf configuration)"));
            }
        }

        @Bean
        public SpringResourceTemplateResolver defaultTemplateResolver() {
            SpringResourceTemplateResolver resolver = new SpringResourceTemplateResolver();
            resolver.setApplicationContext(this.applicationContext);
            resolver.setPrefix(this.properties.getPrefix());
            resolver.setSuffix(this.properties.getSuffix());
            resolver.setTemplateMode(this.properties.getMode());
            if (this.properties.getEncoding() != null) {
                resolver.setCharacterEncoding(this.properties.getEncoding().name());
            }
            resolver.setCacheable(this.properties.isCache());
            Integer order = this.properties.getTemplateResolverOrder();
            if (order != null) {
                resolver.setOrder(order);
            }
            resolver.setCheckExistence(this.properties.isCheckTemplate());
            return resolver;
        }
    }
}

