/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.core.Ordered;

public class ServletWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory>,
Ordered {
    private final ServerProperties serverProperties;

    public ServletWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.serverProperties::getPort).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setPort(arg_0));
        map.from(this.serverProperties::getAddress).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setAddress(arg_0));
        map.from(this.serverProperties.getServlet()::getContextPath).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setContextPath(arg_0));
        map.from(this.serverProperties.getServlet()::getApplicationDisplayName).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setDisplayName(arg_0));
        map.from(this.serverProperties.getServlet()::getSession).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setSession(arg_0));
        map.from(this.serverProperties::getSsl).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setSsl(arg_0));
        map.from(this.serverProperties::getServlet).as(ServerProperties.Servlet::getJsp).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setJsp(arg_0));
        map.from(this.serverProperties::getCompression).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setCompression(arg_0));
        map.from(this.serverProperties::getHttp2).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setHttp2(arg_0));
        map.from(this.serverProperties::getServerHeader).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setServerHeader(arg_0));
        map.from(this.serverProperties.getServlet()::getContextParameters).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setInitParameters(arg_0));
    }
}

