/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.servlet;

import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.h2.H2ConsoleProperties;
import org.springframework.boot.autoconfigure.security.servlet.StaticResourceRequest;
import org.springframework.boot.security.servlet.ApplicationContextRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class PathRequest {
    private PathRequest() {
    }

    public static StaticResourceRequest toStaticResources() {
        return StaticResourceRequest.INSTANCE;
    }

    public static H2ConsoleRequestMatcher toH2Console() {
        return new H2ConsoleRequestMatcher();
    }

    public static final class H2ConsoleRequestMatcher
    extends ApplicationContextRequestMatcher<H2ConsoleProperties> {
        private RequestMatcher delegate;

        private H2ConsoleRequestMatcher() {
            super(H2ConsoleProperties.class);
        }

        protected void initialized(H2ConsoleProperties h2ConsoleProperties) {
            this.delegate = new AntPathRequestMatcher(h2ConsoleProperties.getPath() + "/**");
        }

        protected boolean matches(HttpServletRequest request, H2ConsoleProperties context) {
            return this.delegate.matches(request);
        }
    }
}

