/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.embedded.jetty.JettyCustomizer;
import org.springframework.boot.autoconfigure.web.embedded.tomcat.TomcatCustomizer;
import org.springframework.boot.autoconfigure.web.embedded.undertow.UndertowCustomizer;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.undertow.ConfigurableUndertowWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

public class DefaultServletWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory>,
EnvironmentAware,
Ordered {
    private final ServerProperties serverProperties;
    private Environment environment;

    public DefaultServletWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setLoader(String value) {
    }

    public int getOrder() {
        return 0;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.serverProperties::getPort).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setPort(arg_0));
        map.from(this.serverProperties::getAddress).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setAddress(arg_0));
        map.from(this.serverProperties.getServlet()::getContextPath).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setContextPath(arg_0));
        map.from(this.serverProperties::getDisplayName).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setDisplayName(arg_0));
        map.from(this.serverProperties.getServlet()::getSession).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setSession(arg_0));
        map.from(this.serverProperties::getSsl).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setSsl(arg_0));
        map.from(this.serverProperties::getServlet).as(ServerProperties.Servlet::getJsp).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setJsp(arg_0));
        map.from(this.serverProperties::getCompression).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setCompression(arg_0));
        map.from(this.serverProperties::getHttp2).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setHttp2(arg_0));
        map.from(this.serverProperties::getServerHeader).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setServerHeader(arg_0));
        map.from(() -> factory).whenInstanceOf(TomcatServletWebServerFactory.class).to(tomcatFactory -> {
            TomcatCustomizer.customizeTomcat(this.serverProperties, this.environment, (ConfigurableTomcatWebServerFactory)tomcatFactory);
            TomcatServletCustomizer.customizeTomcat(this.serverProperties, this.environment, tomcatFactory);
        });
        map.from(() -> factory).whenInstanceOf(JettyServletWebServerFactory.class).to(jettyFactory -> JettyCustomizer.customizeJetty(this.serverProperties, this.environment, (ConfigurableJettyWebServerFactory)jettyFactory));
        map.from(() -> factory).whenInstanceOf(UndertowServletWebServerFactory.class).to(undertowFactory -> UndertowCustomizer.customizeUndertow(this.serverProperties, this.environment, (ConfigurableUndertowWebServerFactory)undertowFactory));
        map.from(this.serverProperties.getServlet()::getContextParameters).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setInitParameters(arg_0));
    }

    private static class TomcatServletCustomizer {
        private TomcatServletCustomizer() {
        }

        public static void customizeTomcat(ServerProperties serverProperties, Environment environment, TomcatServletWebServerFactory factory) {
            ServerProperties.Tomcat tomcatProperties = serverProperties.getTomcat();
            if (!ObjectUtils.isEmpty(tomcatProperties.getAdditionalTldSkipPatterns())) {
                factory.getTldSkipPatterns().addAll(tomcatProperties.getAdditionalTldSkipPatterns());
            }
            if (tomcatProperties.getRedirectContextRoot() != null) {
                TomcatServletCustomizer.customizeRedirectContextRoot((ConfigurableTomcatWebServerFactory)factory, tomcatProperties.getRedirectContextRoot());
            }
            if (tomcatProperties.getUseRelativeRedirects() != null) {
                TomcatServletCustomizer.customizeUseRelativeRedirects((ConfigurableTomcatWebServerFactory)factory, tomcatProperties.getUseRelativeRedirects());
            }
        }

        private static void customizeRedirectContextRoot(ConfigurableTomcatWebServerFactory factory, boolean redirectContextRoot) {
            factory.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.setMapperContextRootRedirectEnabled(redirectContextRoot)});
        }

        private static void customizeUseRelativeRedirects(ConfigurableTomcatWebServerFactory factory, boolean useRelativeRedirects) {
            factory.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.setUseRelativeRedirects(useRelativeRedirects)});
        }
    }
}

