/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.embedded.jetty.JettyCustomizer;
import org.springframework.boot.autoconfigure.web.embedded.tomcat.TomcatCustomizer;
import org.springframework.boot.autoconfigure.web.embedded.undertow.UndertowCustomizer;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.embedded.jetty.JettyReactiveWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatReactiveWebServerFactory;
import org.springframework.boot.web.embedded.undertow.ConfigurableUndertowWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowReactiveWebServerFactory;
import org.springframework.boot.web.reactive.server.ConfigurableReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

public class DefaultReactiveWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableReactiveWebServerFactory>,
EnvironmentAware,
Ordered {
    private final ServerProperties serverProperties;
    private Environment environment;

    public DefaultReactiveWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void customize(ConfigurableReactiveWebServerFactory factory) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.serverProperties::getPort).to(arg_0 -> ((ConfigurableReactiveWebServerFactory)factory).setPort(arg_0));
        map.from(this.serverProperties::getAddress).to(arg_0 -> ((ConfigurableReactiveWebServerFactory)factory).setAddress(arg_0));
        map.from(this.serverProperties::getSsl).to(arg_0 -> ((ConfigurableReactiveWebServerFactory)factory).setSsl(arg_0));
        map.from(this.serverProperties::getCompression).to(arg_0 -> ((ConfigurableReactiveWebServerFactory)factory).setCompression(arg_0));
        map.from(this.serverProperties::getHttp2).to(arg_0 -> ((ConfigurableReactiveWebServerFactory)factory).setHttp2(arg_0));
        map.from(() -> factory).whenInstanceOf(TomcatReactiveWebServerFactory.class).to(tomcatFactory -> TomcatCustomizer.customizeTomcat(this.serverProperties, this.environment, (ConfigurableTomcatWebServerFactory)tomcatFactory));
        map.from(() -> factory).whenInstanceOf(JettyReactiveWebServerFactory.class).to(jettyFactory -> JettyCustomizer.customizeJetty(this.serverProperties, this.environment, (ConfigurableJettyWebServerFactory)jettyFactory));
        map.from(() -> factory).whenInstanceOf(UndertowReactiveWebServerFactory.class).to(undertowFactory -> UndertowCustomizer.customizeUndertow(this.serverProperties, this.environment, (ConfigurableUndertowWebServerFactory)undertowFactory));
    }
}

