/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.convert.DefaultDurationUnit;
import org.springframework.http.CacheControl;

@ConfigurationProperties(prefix="spring.resources", ignoreUnknownFields=false)
public class ResourceProperties {
    private static final String[] CLASSPATH_RESOURCE_LOCATIONS = new String[]{"classpath:/META-INF/resources/", "classpath:/resources/", "classpath:/static/", "classpath:/public/"};
    private String[] staticLocations = CLASSPATH_RESOURCE_LOCATIONS;
    private boolean addMappings = true;
    private final Chain chain = new Chain();
    private final Cache cache = new Cache();

    public String[] getStaticLocations() {
        return this.staticLocations;
    }

    public void setStaticLocations(String[] staticLocations) {
        this.staticLocations = this.appendSlashIfNecessary(staticLocations);
    }

    private String[] appendSlashIfNecessary(String[] staticLocations) {
        String[] normalized = new String[staticLocations.length];
        for (int i = 0; i < staticLocations.length; ++i) {
            String location = staticLocations[i];
            normalized[i] = location.endsWith("/") ? location : location + "/";
        }
        return normalized;
    }

    public boolean isAddMappings() {
        return this.addMappings;
    }

    public void setAddMappings(boolean addMappings) {
        this.addMappings = addMappings;
    }

    public Chain getChain() {
        return this.chain;
    }

    public Cache getCache() {
        return this.cache;
    }

    public static class Cache {
        @DefaultDurationUnit(value=ChronoUnit.SECONDS)
        private Duration period;
        private final Cachecontrol cachecontrol = new Cachecontrol();

        public Duration getPeriod() {
            return this.period;
        }

        public void setPeriod(Duration period) {
            this.period = period;
        }

        public Cachecontrol getCachecontrol() {
            return this.cachecontrol;
        }

        public static class Cachecontrol {
            @DefaultDurationUnit(value=ChronoUnit.SECONDS)
            private Duration maxAge;
            private Boolean noCache;
            private Boolean noStore;
            private Boolean mustRevalidate;
            private Boolean noTransform;
            private Boolean cachePublic;
            private Boolean cachePrivate;
            private Boolean proxyRevalidate;
            @DefaultDurationUnit(value=ChronoUnit.SECONDS)
            private Duration staleWhileRevalidate;
            @DefaultDurationUnit(value=ChronoUnit.SECONDS)
            private Duration staleIfError;
            @DefaultDurationUnit(value=ChronoUnit.SECONDS)
            private Duration sMaxAge;

            public Duration getMaxAge() {
                return this.maxAge;
            }

            public void setMaxAge(Duration maxAge) {
                this.maxAge = maxAge;
            }

            public Boolean getNoCache() {
                return this.noCache;
            }

            public void setNoCache(Boolean noCache) {
                this.noCache = noCache;
            }

            public Boolean getNoStore() {
                return this.noStore;
            }

            public void setNoStore(Boolean noStore) {
                this.noStore = noStore;
            }

            public Boolean getMustRevalidate() {
                return this.mustRevalidate;
            }

            public void setMustRevalidate(Boolean mustRevalidate) {
                this.mustRevalidate = mustRevalidate;
            }

            public Boolean getNoTransform() {
                return this.noTransform;
            }

            public void setNoTransform(Boolean noTransform) {
                this.noTransform = noTransform;
            }

            public Boolean getCachePublic() {
                return this.cachePublic;
            }

            public void setCachePublic(Boolean cachePublic) {
                this.cachePublic = cachePublic;
            }

            public Boolean getCachePrivate() {
                return this.cachePrivate;
            }

            public void setCachePrivate(Boolean cachePrivate) {
                this.cachePrivate = cachePrivate;
            }

            public Boolean getProxyRevalidate() {
                return this.proxyRevalidate;
            }

            public void setProxyRevalidate(Boolean proxyRevalidate) {
                this.proxyRevalidate = proxyRevalidate;
            }

            public Duration getStaleWhileRevalidate() {
                return this.staleWhileRevalidate;
            }

            public void setStaleWhileRevalidate(Duration staleWhileRevalidate) {
                this.staleWhileRevalidate = staleWhileRevalidate;
            }

            public Duration getStaleIfError() {
                return this.staleIfError;
            }

            public void setStaleIfError(Duration staleIfError) {
                this.staleIfError = staleIfError;
            }

            public Duration getSMaxAge() {
                return this.sMaxAge;
            }

            public void setSMaxAge(Duration sMaxAge) {
                this.sMaxAge = sMaxAge;
            }

            public CacheControl toHttpCacheControl() {
                CacheControl cacheControl = this.createCacheControl();
                this.callIfTrue(this.mustRevalidate, cacheControl, CacheControl::mustRevalidate);
                this.callIfTrue(this.noTransform, cacheControl, CacheControl::noTransform);
                this.callIfTrue(this.cachePublic, cacheControl, CacheControl::cachePublic);
                this.callIfTrue(this.cachePrivate, cacheControl, CacheControl::cachePrivate);
                this.callIfTrue(this.proxyRevalidate, cacheControl, CacheControl::proxyRevalidate);
                if (this.staleWhileRevalidate != null) {
                    cacheControl.staleWhileRevalidate(this.staleWhileRevalidate.getSeconds(), TimeUnit.SECONDS);
                }
                if (this.staleIfError != null) {
                    cacheControl.staleIfError(this.staleIfError.getSeconds(), TimeUnit.SECONDS);
                }
                if (this.sMaxAge != null) {
                    cacheControl.sMaxAge(this.sMaxAge.getSeconds(), TimeUnit.SECONDS);
                }
                return cacheControl;
            }

            private CacheControl createCacheControl() {
                if (Boolean.TRUE.equals(this.noStore)) {
                    return CacheControl.noStore();
                }
                if (Boolean.TRUE.equals(this.noCache)) {
                    return CacheControl.noCache();
                }
                if (this.maxAge != null) {
                    return CacheControl.maxAge((long)this.maxAge.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
                }
                return CacheControl.empty();
            }

            private <T> void callIfTrue(Boolean property, T instance, Consumer<T> call) {
                if (Boolean.TRUE.equals(property)) {
                    call.accept(instance);
                }
            }
        }
    }

    public static class Fixed {
        private boolean enabled;
        private String[] paths = new String[]{"/**"};
        private String version;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String[] getPaths() {
            return this.paths;
        }

        public void setPaths(String[] paths) {
            this.paths = paths;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }

    public static class Content {
        private boolean enabled;
        private String[] paths = new String[]{"/**"};

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String[] getPaths() {
            return this.paths;
        }

        public void setPaths(String[] paths) {
            this.paths = paths;
        }
    }

    public static class Strategy {
        private final Fixed fixed = new Fixed();
        private final Content content = new Content();

        public Fixed getFixed() {
            return this.fixed;
        }

        public Content getContent() {
            return this.content;
        }
    }

    public static class Chain {
        private Boolean enabled;
        private boolean cache = true;
        private boolean htmlApplicationCache = false;
        private boolean gzipped = false;
        private final Strategy strategy = new Strategy();

        public Boolean getEnabled() {
            return Chain.getEnabled(this.getStrategy().getFixed().isEnabled(), this.getStrategy().getContent().isEnabled(), this.enabled);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isCache() {
            return this.cache;
        }

        public void setCache(boolean cache) {
            this.cache = cache;
        }

        public Strategy getStrategy() {
            return this.strategy;
        }

        public boolean isHtmlApplicationCache() {
            return this.htmlApplicationCache;
        }

        public void setHtmlApplicationCache(boolean htmlApplicationCache) {
            this.htmlApplicationCache = htmlApplicationCache;
        }

        public boolean isGzipped() {
            return this.gzipped;
        }

        public void setGzipped(boolean gzipped) {
            this.gzipped = gzipped;
        }

        static Boolean getEnabled(boolean fixedEnabled, boolean contentEnabled, Boolean chainEnabled) {
            return fixedEnabled || contentEnabled ? Boolean.TRUE : chainEnabled;
        }
    }
}

