/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.security.ApplicationContextRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class StaticResourceRequest {
    private StaticResourceRequest() {
    }

    public static StaticResourceRequestMatcher toCommonLocations() {
        return StaticResourceRequest.to(EnumSet.allOf(Location.class));
    }

    public static StaticResourceRequestMatcher to(Location first, Location ... rest) {
        return StaticResourceRequest.to(EnumSet.of(first, rest));
    }

    public static StaticResourceRequestMatcher to(Set<Location> locations) {
        Assert.notNull(locations, (String)"Locations must not be null");
        return new StaticResourceRequestMatcher(new LinkedHashSet<Location>(locations));
    }

    public static final class StaticResourceRequestMatcher
    extends ApplicationContextRequestMatcher<ServerProperties> {
        private final Set<Location> locations;
        private RequestMatcher delegate;

        private StaticResourceRequestMatcher(Set<Location> locations) {
            super(ServerProperties.class);
            this.locations = locations;
        }

        public StaticResourceRequestMatcher excluding(Location first, Location ... rest) {
            return this.excluding(EnumSet.of(first, rest));
        }

        public StaticResourceRequestMatcher excluding(Set<Location> locations) {
            Assert.notNull(locations, (String)"Locations must not be null");
            LinkedHashSet<Location> subset = new LinkedHashSet<Location>(this.locations);
            subset.removeAll(locations);
            return new StaticResourceRequestMatcher(subset);
        }

        protected void initialized(ServerProperties serverProperties) {
            this.delegate = new OrRequestMatcher(this.getDelegateMatchers(serverProperties));
        }

        private List<RequestMatcher> getDelegateMatchers(ServerProperties serverProperties) {
            return this.getPatterns(serverProperties).map(AntPathRequestMatcher::new).collect(Collectors.toList());
        }

        private Stream<String> getPatterns(ServerProperties serverProperties) {
            return this.locations.stream().flatMap(Location::getPatterns).map(serverProperties.getServlet()::getPath);
        }

        protected boolean matches(HttpServletRequest request, ServerProperties context) {
            return this.delegate.matches(request);
        }
    }

    public static enum Location {
        CSS("/css/**"),
        JAVA_SCRIPT("/js/**"),
        IMAGES("/images/**"),
        WEB_JARS("/webjars/**"),
        FAVICON("/**/favicon.ico");

        private String[] patterns;

        private Location(String ... patterns) {
            this.patterns = patterns;
        }

        Stream<String> getPatterns() {
            return Arrays.stream(this.patterns);
        }
    }
}

