/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jooq;

import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.RecordListenerProvider;
import org.jooq.RecordMapperProvider;
import org.jooq.TransactionProvider;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jooq.JooqExceptionTranslator;
import org.springframework.boot.autoconfigure.jooq.JooqProperties;
import org.springframework.boot.autoconfigure.jooq.SpringTransactionProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

@org.springframework.context.annotation.Configuration
@ConditionalOnClass(value={DSLContext.class})
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class JooqAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={DataSourceConnectionProvider.class})
    public DataSourceConnectionProvider dataSourceConnectionProvider(DataSource dataSource) {
        return new DataSourceConnectionProvider((DataSource)new TransactionAwareDataSourceProxy(dataSource));
    }

    @Bean
    @ConditionalOnBean(value={PlatformTransactionManager.class})
    public SpringTransactionProvider transactionProvider(PlatformTransactionManager txManager) {
        return new SpringTransactionProvider(txManager);
    }

    @Bean
    public DefaultExecuteListenerProvider jooqExceptionTranslatorExecuteListenerProvider() {
        return new DefaultExecuteListenerProvider((ExecuteListener)new JooqExceptionTranslator());
    }

    @org.springframework.context.annotation.Configuration
    @ConditionalOnMissingBean(value={DSLContext.class})
    @EnableConfigurationProperties(value={JooqProperties.class})
    public static class DslContextConfiguration {
        private final JooqProperties properties;
        private final ConnectionProvider connection;
        private final DataSource dataSource;
        private final TransactionProvider transactionProvider;
        private final RecordMapperProvider recordMapperProvider;
        private final Settings settings;
        private final RecordListenerProvider[] recordListenerProviders;
        private final ExecuteListenerProvider[] executeListenerProviders;
        private final VisitListenerProvider[] visitListenerProviders;

        public DslContextConfiguration(JooqProperties properties, ConnectionProvider connectionProvider, DataSource dataSource, ObjectProvider<TransactionProvider> transactionProvider, ObjectProvider<RecordMapperProvider> recordMapperProvider, ObjectProvider<Settings> settings, ObjectProvider<RecordListenerProvider[]> recordListenerProviders, ExecuteListenerProvider[] executeListenerProviders, ObjectProvider<VisitListenerProvider[]> visitListenerProviders) {
            this.properties = properties;
            this.connection = connectionProvider;
            this.dataSource = dataSource;
            this.transactionProvider = (TransactionProvider)transactionProvider.getIfAvailable();
            this.recordMapperProvider = (RecordMapperProvider)recordMapperProvider.getIfAvailable();
            this.settings = (Settings)settings.getIfAvailable();
            this.recordListenerProviders = (RecordListenerProvider[])recordListenerProviders.getIfAvailable();
            this.executeListenerProviders = executeListenerProviders;
            this.visitListenerProviders = (VisitListenerProvider[])visitListenerProviders.getIfAvailable();
        }

        @Bean
        public DefaultDSLContext dslContext(Configuration configuration) {
            return new DefaultDSLContext(configuration);
        }

        @Bean
        @ConditionalOnMissingBean(value={Configuration.class})
        public DefaultConfiguration jooqConfiguration() {
            DefaultConfiguration configuration = new DefaultConfiguration();
            configuration.set(this.properties.determineSqlDialect(this.dataSource));
            configuration.set(this.connection);
            if (this.transactionProvider != null) {
                configuration.set(this.transactionProvider);
            }
            if (this.recordMapperProvider != null) {
                configuration.set(this.recordMapperProvider);
            }
            if (this.settings != null) {
                configuration.set(this.settings);
            }
            configuration.set(this.recordListenerProviders);
            configuration.set(this.executeListenerProviders);
            configuration.set(this.visitListenerProviders);
            return configuration;
        }
    }
}

