/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

final class BeanTypeRegistry
implements SmartInitializingSingleton {
    private static final Log logger = LogFactory.getLog(BeanTypeRegistry.class);
    static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";
    private static final String BEAN_NAME = BeanTypeRegistry.class.getName();
    private final DefaultListableBeanFactory beanFactory;
    private final Map<String, Class<?>> beanTypes = new HashMap();
    private int lastBeanDefinitionCount = 0;

    private BeanTypeRegistry(DefaultListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    static BeanTypeRegistry get(ListableBeanFactory beanFactory) {
        Assert.isInstanceOf(DefaultListableBeanFactory.class, (Object)beanFactory);
        DefaultListableBeanFactory listableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        Assert.isTrue((boolean)listableBeanFactory.isAllowEagerClassLoading(), (String)"Bean factory must allow eager class loading");
        if (!listableBeanFactory.containsLocalBean(BEAN_NAME)) {
            RootBeanDefinition bd = new RootBeanDefinition(BeanTypeRegistry.class);
            bd.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)beanFactory);
            listableBeanFactory.registerBeanDefinition(BEAN_NAME, (BeanDefinition)bd);
        }
        return (BeanTypeRegistry)listableBeanFactory.getBean(BEAN_NAME, BeanTypeRegistry.class);
    }

    Set<String> getNamesForType(Class<?> type) {
        this.updateTypesIfNecessary();
        LinkedHashSet<String> matches = new LinkedHashSet<String>();
        for (Map.Entry<String, Class<?>> entry : this.beanTypes.entrySet()) {
            if (entry.getValue() == null || !type.isAssignableFrom(entry.getValue())) continue;
            matches.add(entry.getKey());
        }
        return matches;
    }

    Set<String> getNamesForAnnotation(Class<? extends Annotation> annotation) {
        this.updateTypesIfNecessary();
        LinkedHashSet<String> matches = new LinkedHashSet<String>();
        for (Map.Entry<String, Class<?>> entry : this.beanTypes.entrySet()) {
            if (entry.getValue() == null || AnnotationUtils.findAnnotation(entry.getValue(), annotation) == null) continue;
            matches.add(entry.getKey());
        }
        return matches;
    }

    public void afterSingletonsInstantiated() {
        this.beanTypes.clear();
        this.lastBeanDefinitionCount = 0;
    }

    private void addBeanType(String name) {
        if (this.beanFactory.containsSingleton(name)) {
            this.beanTypes.put(name, this.beanFactory.getType(name));
        } else if (!this.beanFactory.isAlias(name)) {
            this.addBeanTypeForNonAliasDefinition(name);
        }
    }

    private void addBeanTypeForNonAliasDefinition(String name) {
        try {
            String factoryName = "&" + name;
            RootBeanDefinition beanDefinition = (RootBeanDefinition)this.beanFactory.getMergedBeanDefinition(name);
            if (!beanDefinition.isAbstract() && !this.requiresEagerInit(beanDefinition.getFactoryBeanName())) {
                if (this.beanFactory.isFactoryBean(factoryName)) {
                    Class<?> factoryBeanGeneric = this.getFactoryBeanGeneric((ConfigurableListableBeanFactory)this.beanFactory, (BeanDefinition)beanDefinition);
                    this.beanTypes.put(name, factoryBeanGeneric);
                    this.beanTypes.put(factoryName, this.beanFactory.getType(factoryName));
                } else {
                    this.beanTypes.put(name, this.beanFactory.getType(name));
                }
            }
        }
        catch (CannotLoadBeanClassException ex) {
            this.logIgnoredError("bean class loading failure for bean", name, (Exception)((Object)ex));
        }
        catch (BeanDefinitionStoreException ex) {
            this.logIgnoredError("unresolvable metadata in bean definition", name, (Exception)((Object)ex));
        }
    }

    private void logIgnoredError(String message, String name, Exception ex) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ignoring " + message + " '" + name + "'"), (Throwable)ex);
        }
    }

    private boolean requiresEagerInit(String factoryBeanName) {
        return factoryBeanName != null && this.beanFactory.isFactoryBean(factoryBeanName) && !this.beanFactory.containsSingleton(factoryBeanName);
    }

    private void updateTypesIfNecessary() {
        if (this.lastBeanDefinitionCount != this.beanFactory.getBeanDefinitionCount()) {
            Iterator names = this.beanFactory.getBeanNamesIterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (this.beanTypes.containsKey(name)) continue;
                this.addBeanType(name);
            }
            this.lastBeanDefinitionCount = this.beanFactory.getBeanDefinitionCount();
        }
    }

    private Class<?> getFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition) {
        try {
            return this.doGetFactoryBeanGeneric(beanFactory, definition);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Class<?> doGetFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition) throws Exception, ClassNotFoundException, LinkageError {
        if (StringUtils.hasLength((String)definition.getFactoryBeanName()) && StringUtils.hasLength((String)definition.getFactoryMethodName())) {
            return this.getConfigurationClassFactoryBeanGeneric(beanFactory, definition);
        }
        if (StringUtils.hasLength((String)definition.getBeanClassName())) {
            return this.getDirectFactoryBeanGeneric(beanFactory, definition);
        }
        return null;
    }

    private Class<?> getConfigurationClassFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition) throws Exception {
        Method method = this.getFactoryMethod(beanFactory, definition);
        Class<?> generic = ResolvableType.forMethodReturnType((Method)method).as(FactoryBean.class).resolveGeneric(new int[0]);
        if ((generic == null || generic.equals(Object.class)) && definition.hasAttribute(FACTORY_BEAN_OBJECT_TYPE)) {
            generic = this.getTypeFromAttribute(definition.getAttribute(FACTORY_BEAN_OBJECT_TYPE));
        }
        return generic;
    }

    private Method getFactoryMethod(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition) throws Exception {
        MethodMetadata factoryMethodMetadata;
        if (definition instanceof AnnotatedBeanDefinition && (factoryMethodMetadata = ((AnnotatedBeanDefinition)definition).getFactoryMethodMetadata()) instanceof StandardMethodMetadata) {
            return ((StandardMethodMetadata)factoryMethodMetadata).getIntrospectedMethod();
        }
        BeanDefinition factoryDefinition = beanFactory.getBeanDefinition(definition.getFactoryBeanName());
        Class factoryClass = ClassUtils.forName((String)factoryDefinition.getBeanClassName(), (ClassLoader)beanFactory.getBeanClassLoader());
        return this.getFactoryMethod(definition, factoryClass);
    }

    private Method getFactoryMethod(BeanDefinition definition, Class<?> factoryClass) {
        Method uniqueMethod = null;
        for (Method candidate : this.getCandidateFactoryMethods(definition, factoryClass)) {
            if (!candidate.getName().equals(definition.getFactoryMethodName())) continue;
            if (uniqueMethod == null) {
                uniqueMethod = candidate;
                continue;
            }
            if (this.hasMatchingParameterTypes(candidate, uniqueMethod)) continue;
            return null;
        }
        return uniqueMethod;
    }

    private Method[] getCandidateFactoryMethods(BeanDefinition definition, Class<?> factoryClass) {
        return this.shouldConsiderNonPublicMethods(definition) ? ReflectionUtils.getAllDeclaredMethods(factoryClass) : factoryClass.getMethods();
    }

    private boolean shouldConsiderNonPublicMethods(BeanDefinition definition) {
        return definition instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)definition).isNonPublicAccessAllowed();
    }

    private boolean hasMatchingParameterTypes(Method candidate, Method current) {
        return Arrays.equals(candidate.getParameterTypes(), current.getParameterTypes());
    }

    private Class<?> getDirectFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition) throws ClassNotFoundException, LinkageError {
        Class factoryBeanClass = ClassUtils.forName((String)definition.getBeanClassName(), (ClassLoader)beanFactory.getBeanClassLoader());
        Class<?> generic = ResolvableType.forClass((Class)factoryBeanClass).as(FactoryBean.class).resolveGeneric(new int[0]);
        if ((generic == null || generic.equals(Object.class)) && definition.hasAttribute(FACTORY_BEAN_OBJECT_TYPE)) {
            generic = this.getTypeFromAttribute(definition.getAttribute(FACTORY_BEAN_OBJECT_TYPE));
        }
        return generic;
    }

    private Class<?> getTypeFromAttribute(Object attribute) throws ClassNotFoundException, LinkageError {
        if (attribute instanceof Class) {
            return (Class)attribute;
        }
        if (attribute instanceof String) {
            return ClassUtils.forName((String)((String)attribute), null);
        }
        return null;
    }
}

