/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpMethod;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.http.gzip")
public class GzipFilterProperties {
    private final Map<String, String> initParameters = new HashMap<String, String>();
    private Integer bufferSize;
    private Integer minGzipSize;
    private Integer deflateCompressionLevel;
    private Boolean deflateNoWrap;
    private List<HttpMethod> methods;
    private List<MimeType> mimeTypes;
    private List<MimeType> excludedMimeTypes;
    private String excludedAgents;
    private String excludeAgentPatterns;
    private String excludePaths;
    private String excludePathPatterns;
    private String vary;

    public GzipFilterProperties() {
        this.addInitParameter("checkGzExists", false);
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(Integer bufferSize) {
        this.addInitParameter("bufferSize", bufferSize);
        this.bufferSize = bufferSize;
    }

    public Integer getMinGzipSize() {
        return this.minGzipSize;
    }

    public void setMinGzipSize(Integer minGzipSize) {
        this.addInitParameter("minGzipSize", minGzipSize);
        this.minGzipSize = minGzipSize;
    }

    public Integer getDeflateCompressionLevel() {
        return this.deflateCompressionLevel;
    }

    public void setDeflateCompressionLevel(Integer deflateCompressionLevel) {
        this.addInitParameter("deflateCompressionLevel", deflateCompressionLevel);
        this.deflateCompressionLevel = deflateCompressionLevel;
    }

    public Boolean getDeflateNoWrap() {
        return this.deflateNoWrap;
    }

    public void setDeflateNoWrap(Boolean deflateNoWrap) {
        this.addInitParameter("deflateNoWrap", deflateNoWrap);
        this.deflateNoWrap = deflateNoWrap;
    }

    public List<HttpMethod> getMethods() {
        return this.methods;
    }

    public void setMethods(List<HttpMethod> methods) {
        this.addInitParameter("methods", StringUtils.collectionToCommaDelimitedString(methods));
        this.methods = methods;
    }

    public List<MimeType> getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(List<MimeType> mimeTypes) {
        this.addInitParameter("mimeTypes", StringUtils.collectionToCommaDelimitedString(mimeTypes));
        this.mimeTypes = mimeTypes;
    }

    public List<MimeType> getExcludedMimeTypes() {
        return this.excludedMimeTypes;
    }

    public void setExcludedMimeTypes(List<MimeType> excludedMimeTypes) {
        this.addInitParameter("excludedMimeTypes", StringUtils.collectionToCommaDelimitedString(excludedMimeTypes));
        this.excludedMimeTypes = excludedMimeTypes;
    }

    public String getExcludedAgents() {
        return this.excludedAgents;
    }

    public void setExcludedAgents(String excludedAgents) {
        this.addInitParameter("excludedAgents", excludedAgents);
        this.excludedAgents = excludedAgents;
    }

    public String getExcludeAgentPatterns() {
        return this.excludeAgentPatterns;
    }

    public void setExcludeAgentPatterns(String excludeAgentPatterns) {
        this.addInitParameter("excludeAgentPatterns", excludeAgentPatterns);
        this.excludeAgentPatterns = excludeAgentPatterns;
    }

    public String getExcludePaths() {
        return this.excludePaths;
    }

    public void setExcludePaths(String excludePaths) {
        this.addInitParameter("excludePaths", excludePaths);
        this.excludePaths = excludePaths;
    }

    public String getExcludePathPatterns() {
        return this.excludePathPatterns;
    }

    public void setExcludePathPatterns(String excludePathPatterns) {
        this.addInitParameter("excludePathPatterns", excludePathPatterns);
        this.excludePathPatterns = excludePathPatterns;
    }

    public String getVary() {
        return this.vary;
    }

    public void setVary(String vary) {
        this.addInitParameter("vary", vary);
        this.vary = vary;
    }

    Map<String, String> getAsInitParameters() {
        return this.initParameters;
    }

    private void addInitParameter(String name, Integer value) {
        if (value != null) {
            this.initParameters.put(name, value.toString());
        }
    }

    private void addInitParameter(String name, Boolean value) {
        if (value != null) {
            this.initParameters.put(name, value.toString());
        }
    }

    private void addInitParameter(String name, String value) {
        if (value != null) {
            this.initParameters.put(name, value.toString());
        }
    }
}

