/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.websocket;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.web.NonEmbeddedServletContainerFactory;
import org.springframework.core.ResolvableType;

public abstract class WebSocketContainerCustomizer<T extends EmbeddedServletContainerFactory>
implements EmbeddedServletContainerCustomizer {
    private Log logger = LogFactory.getLog(this.getClass());

    public void customize(ConfigurableEmbeddedServletContainer container) {
        if (container instanceof NonEmbeddedServletContainerFactory) {
            this.logger.info((Object)"NonEmbeddedServletContainerFactory detected. Websockets support should be native so this normally is not a problem.");
            return;
        }
        if (this.getContainerType().isAssignableFrom(container.getClass())) {
            this.doCustomize((EmbeddedServletContainerFactory)container);
        }
    }

    protected Class<?> getContainerType() {
        return ResolvableType.forClass(WebSocketContainerCustomizer.class, this.getClass()).resolveGeneric(new int[0]);
    }

    protected abstract void doCustomize(T var1);
}

