/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.freemarker;

import java.util.ArrayList;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerProperties;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactoryBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;
import org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver;

@Configuration
@ConditionalOnClass(value={freemarker.template.Configuration.class, FreeMarkerConfigurationFactory.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={FreeMarkerProperties.class})
public class FreeMarkerAutoConfiguration {
    @Autowired
    private final ResourceLoader resourceLoader = new DefaultResourceLoader();
    @Autowired
    private FreeMarkerProperties properties;

    @PostConstruct
    public void checkTemplateLocationExists() {
        if (this.properties.isCheckTemplateLocation()) {
            Resource templatePathResource = null;
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String templateLoaderPath : this.properties.getTemplateLoaderPath()) {
                Resource resource = this.resourceLoader.getResource(templateLoaderPath);
                resources.add(resource);
                if (!resource.exists()) continue;
                templatePathResource = resource;
                break;
            }
            Assert.notNull(templatePathResource, (String)("Cannot find template location(s): " + resources + " (please add some templates, " + "check your FreeMarker configuration, or set " + "spring.freemarker.checkTemplateLocation=false)"));
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class})
    @ConditionalOnWebApplication
    public static class FreeMarkerWebConfiguration
    extends FreeMarkerConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={FreeMarkerConfig.class})
        public FreeMarkerConfigurer freeMarkerConfigurer() {
            FreeMarkerConfigurer configurer = new FreeMarkerConfigurer();
            this.applyProperties((FreeMarkerConfigurationFactory)configurer);
            return configurer;
        }

        @Bean
        public freemarker.template.Configuration freeMarkerConfiguration(FreeMarkerConfig configurer) {
            return configurer.getConfiguration();
        }

        @Bean
        @ConditionalOnMissingBean(name={"freeMarkerViewResolver"})
        @ConditionalOnProperty(name={"spring.freemarker.enabled"}, matchIfMissing=true)
        public FreeMarkerViewResolver freeMarkerViewResolver() {
            FreeMarkerViewResolver resolver = new FreeMarkerViewResolver();
            this.properties.applyToViewResolver(resolver);
            return resolver;
        }
    }

    @Configuration
    @ConditionalOnNotWebApplication
    public static class FreeMarkerNonWebConfiguration
    extends FreeMarkerConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public FreeMarkerConfigurationFactoryBean freeMarkerConfiguration() {
            FreeMarkerConfigurationFactoryBean freeMarkerFactoryBean = new FreeMarkerConfigurationFactoryBean();
            this.applyProperties((FreeMarkerConfigurationFactory)freeMarkerFactoryBean);
            return freeMarkerFactoryBean;
        }
    }

    protected static class FreeMarkerConfiguration {
        @Autowired
        protected FreeMarkerProperties properties;

        protected FreeMarkerConfiguration() {
        }

        protected void applyProperties(FreeMarkerConfigurationFactory factory) {
            factory.setTemplateLoaderPaths(this.properties.getTemplateLoaderPath());
            factory.setDefaultEncoding(this.properties.getCharset());
            Properties settings = new Properties();
            settings.putAll(this.properties.getSettings());
            factory.setFreemarkerSettings(settings);
        }
    }
}

