/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.Arrays;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.web.servlet.DispatcherServlet;

@Order(value=-2147483648)
@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={DispatcherServlet.class})
@AutoConfigureAfter(value={EmbeddedServletContainerAutoConfiguration.class})
public class DispatcherServletAutoConfiguration {
    public static final String DEFAULT_DISPATCHER_SERVLET_BEAN_NAME = "dispatcherServlet";
    public static final String DEFAULT_DISPATCHER_SERVLET_REGISTRATION_BEAN_NAME = "dispatcherServletRegistration";

    private static ConditionOutcome checkServlets(ConfigurableListableBeanFactory beanFactory) {
        List<String> servlets = Arrays.asList(beanFactory.getBeanNamesForType(DispatcherServlet.class, false, false));
        boolean containsDispatcherBean = beanFactory.containsBean(DEFAULT_DISPATCHER_SERVLET_BEAN_NAME);
        if (servlets.isEmpty()) {
            if (containsDispatcherBean) {
                return ConditionOutcome.noMatch("found no DispatcherServlet but a non-DispatcherServlet named dispatcherServlet");
            }
            return ConditionOutcome.match("no DispatcherServlet found");
        }
        if (servlets.contains(DEFAULT_DISPATCHER_SERVLET_BEAN_NAME)) {
            return ConditionOutcome.noMatch("found DispatcherServlet named dispatcherServlet");
        }
        if (containsDispatcherBean) {
            return ConditionOutcome.noMatch("found non-DispatcherServlet named dispatcherServlet");
        }
        return ConditionOutcome.match("one or more DispatcherServlets found and none is named dispatcherServlet");
    }

    private static ConditionOutcome checkServletRegistrations(ConfigurableListableBeanFactory beanFactory) {
        List<String> registrations = Arrays.asList(beanFactory.getBeanNamesForType(ServletRegistrationBean.class, false, false));
        boolean containsDispatcherRegistrationBean = beanFactory.containsBean(DEFAULT_DISPATCHER_SERVLET_REGISTRATION_BEAN_NAME);
        if (registrations.isEmpty()) {
            if (containsDispatcherRegistrationBean) {
                return ConditionOutcome.noMatch("found no ServletRegistrationBean but a non-ServletRegistrationBean named dispatcherServletRegistration");
            }
            return ConditionOutcome.match("no ServletRegistrationBean found");
        }
        if (registrations.contains(DEFAULT_DISPATCHER_SERVLET_REGISTRATION_BEAN_NAME)) {
            return ConditionOutcome.noMatch("found ServletRegistrationBean named dispatcherServletRegistration");
        }
        if (containsDispatcherRegistrationBean) {
            return ConditionOutcome.noMatch("found non-ServletRegistrationBean named dispatcherServletRegistration");
        }
        return ConditionOutcome.match("one or more ServletRegistrationBeans is found and none is named dispatcherServletRegistration");
    }

    @Order(value=0x7FFFFFF5)
    private static class DefaultDispatcherServletCondition
    extends SpringBootCondition {
        private DefaultDispatcherServletCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            ConditionOutcome outcome = DispatcherServletAutoConfiguration.checkServlets(beanFactory);
            if (!outcome.isMatch()) {
                return outcome;
            }
            return DispatcherServletAutoConfiguration.checkServletRegistrations(beanFactory);
        }
    }

    @Configuration
    @Conditional(value={DefaultDispatcherServletCondition.class})
    @ConditionalOnClass(value={ServletRegistration.class})
    protected static class DispatcherServletConfiguration {
        @Autowired
        private ServerProperties server;
        @Autowired(required=false)
        private MultipartConfigElement multipartConfig;

        protected DispatcherServletConfiguration() {
        }

        @Bean(name={"dispatcherServlet"})
        public DispatcherServlet dispatcherServlet() {
            return new DispatcherServlet();
        }

        @Bean(name={"dispatcherServletRegistration"})
        public ServletRegistrationBean dispatcherServletRegistration() {
            ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)this.dispatcherServlet(), new String[]{this.server.getServletMapping()});
            registration.setName(DispatcherServletAutoConfiguration.DEFAULT_DISPATCHER_SERVLET_BEAN_NAME);
            if (this.multipartConfig != null) {
                registration.setMultipartConfig(this.multipartConfig);
            }
            return registration;
        }
    }
}

