/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.SecurityPrequisite;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Configuration
@ConditionalOnBean(value={ObjectPostProcessor.class})
@ConditionalOnMissingBean(value={AuthenticationManager.class})
@Order(value=0)
public class AuthenticationManagerConfiguration
extends GlobalAuthenticationConfigurerAdapter {
    private static Log logger = LogFactory.getLog(AuthenticationManagerConfiguration.class);
    @Autowired
    private List<SecurityPrequisite> dependencies;
    @Autowired
    private SecurityProperties security;
    @Autowired
    private ObjectPostProcessor<Object> objectPostProcessor;

    @Bean
    @Primary
    public AuthenticationManager authenticationManager(AuthenticationManagerBuilder auth, ApplicationContext context) throws Exception {
        if (this.isAuthenticationManagerAlreadyConfigured(context)) {
            return new LazyAuthenticationManager(auth);
        }
        BootDefaultingAuthenticationConfigurerAdapter configurer = new BootDefaultingAuthenticationConfigurerAdapter();
        configurer.configure(auth);
        AuthenticationManager manager = (AuthenticationManager)configurer.getAuthenticationManagerBuilder().getOrBuild();
        configurer.configureParent(auth);
        return manager;
    }

    private boolean isAuthenticationManagerAlreadyConfigured(ApplicationContext context) {
        return context.getBeanNamesForType(GlobalAuthenticationConfigurerAdapter.class).length > 2;
    }

    private static class LazyAuthenticationManager
    implements AuthenticationManager {
        private AuthenticationManagerBuilder builder;

        public LazyAuthenticationManager(AuthenticationManagerBuilder builder) {
            this.builder = builder;
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            return ((AuthenticationManager)this.builder.getOrBuild()).authenticate(authentication);
        }
    }

    private class BootDefaultingAuthenticationConfigurerAdapter {
        private AuthenticationManagerBuilder defaultAuth;
        private AuthenticationManager parent;

        private BootDefaultingAuthenticationConfigurerAdapter() {
        }

        public void configureParent(AuthenticationManagerBuilder auth) {
            if (!auth.isConfigured() && this.parent != null) {
                auth.parentAuthenticationManager(this.parent);
            }
        }

        public AuthenticationManagerBuilder getAuthenticationManagerBuilder() {
            return this.defaultAuth;
        }

        public void configure(AuthenticationManagerBuilder auth) throws Exception {
            if (auth.isConfigured()) {
                this.defaultAuth = auth;
                return;
            }
            SecurityProperties.User user = AuthenticationManagerConfiguration.this.security.getUser();
            if (user.isDefaultPassword()) {
                logger.info((Object)("\n\nUsing default security password: " + user.getPassword() + "\n\n"));
            }
            this.defaultAuth = new AuthenticationManagerBuilder(AuthenticationManagerConfiguration.this.objectPostProcessor);
            LinkedHashSet<String> roles = new LinkedHashSet<String>(user.getRole());
            this.parent = (AuthenticationManager)((AuthenticationManagerBuilder)((InMemoryUserDetailsManagerConfigurer)this.defaultAuth.inMemoryAuthentication().withUser(user.getName()).password(user.getPassword()).roles(roles.toArray(new String[roles.size()])).and()).and()).build();
        }
    }

    @Component
    protected static class AuthenticationManagerConfigurationListener
    implements SmartInitializingSingleton {
        @Autowired
        private AuthenticationEventPublisher authenticationEventPublisher;
        @Autowired
        private ApplicationContext context;

        protected AuthenticationManagerConfigurationListener() {
        }

        public void afterSingletonsInstantiated() {
            if (this.context.getBeanNamesForType(AuthenticationManager.class).length == 0) {
                return;
            }
            AuthenticationManager manager = (AuthenticationManager)this.context.getBean(AuthenticationManager.class);
            if (manager instanceof ProviderManager) {
                ((ProviderManager)manager).setAuthenticationEventPublisher(this.authenticationEventPublisher);
            }
        }
    }
}

