/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.hateoas;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.LinkDiscoverers;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.config.EnableEntityLinks;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.plugin.core.Plugin;
import org.springframework.web.bind.annotation.RequestMapping;

@Configuration
@ConditionalOnClass(value={Resource.class, RequestMapping.class, Plugin.class})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class, JacksonAutoConfiguration.class})
public class HypermediaAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={EntityLinks.class})
    @EnableEntityLinks
    protected static class EntityLinksConfiguration {
        protected EntityLinksConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={LinkDiscoverers.class})
    @EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
    protected static class HypermediaConfiguration {
        protected HypermediaConfiguration() {
        }

        @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class, ObjectMapper.class})
        protected static class HalObjectMapperConfiguration {
            @Autowired(required=false)
            private Jackson2ObjectMapperBuilder objectMapperBuilder;

            protected HalObjectMapperConfiguration() {
            }

            @Bean
            public BeanPostProcessor halObjectMapperConfigurer() {
                return new BeanPostProcessor(){

                    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                        if (HalObjectMapperConfiguration.this.objectMapperBuilder != null && bean instanceof ObjectMapper && "_halObjectMapper".equals(beanName)) {
                            HalObjectMapperConfiguration.this.objectMapperBuilder.configure((ObjectMapper)bean);
                        }
                        return bean;
                    }

                    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                        return bean;
                    }
                };
            }
        }
    }
}

