/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.groovy.template;

import groovy.text.markup.MarkupTemplateEngine;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateProperties;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.UrlBasedViewResolver;
import org.springframework.web.servlet.view.groovy.GroovyMarkupConfig;
import org.springframework.web.servlet.view.groovy.GroovyMarkupConfigurer;
import org.springframework.web.servlet.view.groovy.GroovyMarkupViewResolver;

@Configuration
@ConditionalOnClass(value={MarkupTemplateEngine.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={GroovyTemplateProperties.class})
public class GroovyTemplateAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Servlet.class, LocaleContextHolder.class, UrlBasedViewResolver.class})
    @ConditionalOnWebApplication
    public static class GroovyWebConfiguration {
        @Autowired
        private GroovyTemplateProperties properties;

        @Bean
        @ConditionalOnMissingBean(name={"groovyMarkupViewResolver"})
        public GroovyMarkupViewResolver groovyMarkupViewResolver() {
            GroovyMarkupViewResolver resolver = new GroovyMarkupViewResolver();
            this.configureViewResolver((UrlBasedViewResolver)resolver);
            return resolver;
        }

        private void configureViewResolver(UrlBasedViewResolver resolver) {
            resolver.setSuffix(this.properties.getSuffix());
            resolver.setCache(this.properties.isCache());
            resolver.setContentType(this.properties.getContentType());
            resolver.setViewNames(this.properties.getViewNames());
            resolver.setRequestContextAttribute("spring");
            resolver.setOrder(0x7FFFFFF9);
        }
    }

    @Configuration
    @ConditionalOnClass(value={GroovyMarkupConfigurer.class})
    public static class GroovyMarkupConfiguration {
        @Autowired
        private final ResourceLoader resourceLoader = new DefaultResourceLoader();
        @Autowired
        private GroovyTemplateProperties properties;
        @Autowired(required=false)
        private MarkupTemplateEngine templateEngine;

        @PostConstruct
        public void checkTemplateLocationExists() {
            if (this.properties.isCheckTemplateLocation()) {
                Resource resource = this.resourceLoader.getResource(this.properties.getPrefix());
                Assert.state((boolean)resource.exists(), (String)("Cannot find template location: " + resource + " (please add some templates, " + "check your Groovy configuration, or set " + "spring.groovy.template.check-template-location=false)"));
            }
        }

        @Bean
        @ConditionalOnMissingBean(value={GroovyMarkupConfig.class})
        @ConfigurationProperties(prefix="spring.groovy.template.configuration")
        public GroovyMarkupConfigurer groovyMarkupConfigurer() {
            GroovyMarkupConfigurer configurer = new GroovyMarkupConfigurer();
            configurer.setResourceLoaderPath(this.properties.getPrefix());
            configurer.setCacheTemplates(this.properties.isCache());
            if (this.templateEngine != null) {
                configurer.setTemplateEngine(this.templateEngine);
            }
            return configurer;
        }
    }
}

