/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.ActiveMQProperties;
import org.springframework.boot.autoconfigure.jms.JmsTemplateProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={JmsTemplate.class, ConnectionFactory.class})
@EnableConfigurationProperties(value={JmsTemplateProperties.class})
public class JmsTemplateAutoConfiguration {
    @Autowired
    private JmsTemplateProperties properties;
    @Autowired
    private ConnectionFactory connectionFactory;

    @Bean
    @ConditionalOnMissingBean(value={JmsTemplate.class})
    public JmsTemplate jmsTemplate() {
        JmsTemplate jmsTemplate = new JmsTemplate(this.connectionFactory);
        jmsTemplate.setPubSubDomain(this.properties.isPubSubDomain());
        return jmsTemplate;
    }

    @Configuration
    @ConditionalOnClass(value={ActiveMQConnectionFactory.class})
    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    @EnableConfigurationProperties(value={ActiveMQProperties.class})
    protected static class ActiveMQConnectionFactoryCreator {
        @Autowired
        private ActiveMQProperties config;

        protected ActiveMQConnectionFactoryCreator() {
        }

        @Bean
        public ConnectionFactory jmsConnectionFactory() {
            ConnectionFactory connectionFactory = this.getActiveMQConnectionFactory();
            if (this.config.isPooled()) {
                PooledConnectionFactory pool = new PooledConnectionFactory();
                pool.setConnectionFactory(connectionFactory);
                return pool;
            }
            return connectionFactory;
        }

        private ConnectionFactory getActiveMQConnectionFactory() {
            if (StringUtils.hasLength((String)this.config.getUser()) && StringUtils.hasLength((String)this.config.getPassword())) {
                return new ActiveMQConnectionFactory(this.config.getUser(), this.config.getPassword(), this.config.getBrokerUrl());
            }
            return new ActiveMQConnectionFactory(this.config.getBrokerUrl());
        }
    }
}

