/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@Configuration
@ConditionalOnMissingBean(value={MessageSource.class})
@Order(value=-2147483648)
public class MessageSourceAutoConfiguration
implements EnvironmentAware {
    private RelaxedPropertyResolver environment;

    public void setEnvironment(Environment environment) {
        this.environment = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.messages.");
    }

    @Bean
    public MessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        String basename = this.environment.getProperty("basename", "messages");
        messageSource.setBasename(basename);
        return messageSource;
    }
}

