/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplicationErrorEvent;
import org.springframework.boot.autoconfigure.AutoConfigurationReport;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AutoConfigurationReportLoggingInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
SmartApplicationListener {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableApplicationContext applicationContext;
    private AutoConfigurationReport report;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof GenericApplicationContext) {
            this.report = AutoConfigurationReport.get(this.applicationContext.getBeanFactory());
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> type) {
        return ContextRefreshedEvent.class.isAssignableFrom(type) || SpringApplicationErrorEvent.class.isAssignableFrom(type);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            if (((ApplicationContextEvent)event).getApplicationContext() == this.applicationContext) {
                this.logAutoConfigurationReport();
            }
        } else if (event instanceof SpringApplicationErrorEvent && ((SpringApplicationErrorEvent)event).getApplicationContext() == this.applicationContext) {
            this.logAutoConfigurationReport(true);
        }
    }

    private void logAutoConfigurationReport() {
        this.logAutoConfigurationReport(!this.applicationContext.isActive());
    }

    public void logAutoConfigurationReport(boolean isCrashReport) {
        if (this.report == null) {
            if (this.applicationContext == null) {
                this.logger.info((Object)"Unable to provide auto-configuration report due to missing ApplicationContext");
                return;
            }
            this.report = AutoConfigurationReport.get(this.applicationContext.getBeanFactory());
        }
        if (this.report.getConditionAndOutcomesBySource().size() > 0) {
            if (isCrashReport && this.logger.isInfoEnabled() && !this.logger.isDebugEnabled()) {
                this.logger.info((Object)"\n\nError starting ApplicationContext. To display the auto-configuration report enabled debug logging (start with --debug)\n\n");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.getLogMessage(this.report.getConditionAndOutcomesBySource()));
            }
        }
    }

    private StringBuilder getLogMessage(Map<String, AutoConfigurationReport.ConditionAndOutcomes> outcomes) {
        StringBuilder message = new StringBuilder();
        message.append("\n\n\n");
        message.append("=========================\n");
        message.append("AUTO-CONFIGURATION REPORT\n");
        message.append("=========================\n\n\n");
        message.append("Positive matches:\n");
        message.append("-----------------\n");
        for (Map.Entry<String, AutoConfigurationReport.ConditionAndOutcomes> entry : outcomes.entrySet()) {
            if (!entry.getValue().isFullMatch()) continue;
            this.addLogMessage(message, entry.getKey(), entry.getValue());
        }
        message.append("\n\n");
        message.append("Negative matches:\n");
        message.append("-----------------\n");
        for (Map.Entry<String, AutoConfigurationReport.ConditionAndOutcomes> entry : outcomes.entrySet()) {
            if (entry.getValue().isFullMatch()) continue;
            this.addLogMessage(message, entry.getKey(), entry.getValue());
        }
        message.append("\n\n");
        return message;
    }

    private void addLogMessage(StringBuilder message, String source, AutoConfigurationReport.ConditionAndOutcomes conditionAndOutcomes) {
        message.append("\n   " + ClassUtils.getShortName((String)source) + "\n");
        for (AutoConfigurationReport.ConditionAndOutcome conditionAndOutcome : conditionAndOutcomes) {
            message.append("      - ");
            if (StringUtils.hasLength((String)conditionAndOutcome.getOutcome().getMessage())) {
                message.append(conditionAndOutcome.getOutcome().getMessage());
            } else {
                message.append(conditionAndOutcome.getOutcome().isMatch() ? "matched" : "did not match");
            }
            message.append(" (");
            message.append(ClassUtils.getShortName(conditionAndOutcome.getCondition().getClass()));
            message.append(")\n");
        }
    }
}

