/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.docker.compose;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.amqp.autoconfigure.RabbitStreamConnectionDetails;
import org.springframework.boot.amqp.docker.compose.RabbitEnvironment;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class RabbitStreamDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<RabbitStreamConnectionDetails> {
    private static final int RABBITMQ_STREAMS_PORT = 5552;

    protected RabbitStreamDockerComposeConnectionDetailsFactory() {
        super("rabbitmq", new String[0]);
    }

    protected @Nullable RabbitStreamConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        try {
            return new RabbitStreamDockerComposeConnectionDetails(source.getRunningService());
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    static class RabbitStreamDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements RabbitStreamConnectionDetails {
        private final RabbitEnvironment environment;
        private final String host;
        private final int port;

        protected RabbitStreamDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new RabbitEnvironment(service.env());
            this.host = service.host();
            this.port = service.ports().get(5552);
        }

        @Override
        public @Nullable String getUsername() {
            return this.environment.getUsername();
        }

        @Override
        public @Nullable String getPassword() {
            return this.environment.getPassword();
        }

        @Override
        public String getVirtualHost() {
            return "/";
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getPort() {
            return this.port;
        }
    }
}

