/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.autoconfigure;

import java.util.List;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.RetryInterceptorBuilder;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.springframework.amqp.rabbit.support.micrometer.RabbitListenerObservationConvention;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.amqp.autoconfigure.RabbitListenerRetrySettingsCustomizer;
import org.springframework.boot.amqp.autoconfigure.RabbitProperties;
import org.springframework.boot.retry.RetryPolicySettings;
import org.springframework.core.retry.RetryPolicy;
import org.springframework.util.Assert;

public abstract class AbstractRabbitListenerContainerFactoryConfigurer<T extends AbstractRabbitListenerContainerFactory<?>> {
    private @Nullable MessageConverter messageConverter;
    private @Nullable MessageRecoverer messageRecoverer;
    private @Nullable List<RabbitListenerRetrySettingsCustomizer> retrySettingsCustomizers;
    private final RabbitProperties rabbitProperties;
    private @Nullable Executor taskExecutor;
    private @Nullable RabbitListenerObservationConvention observationConvention;

    protected AbstractRabbitListenerContainerFactoryConfigurer(RabbitProperties rabbitProperties) {
        this.rabbitProperties = rabbitProperties;
    }

    protected void setMessageConverter(@Nullable MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    protected void setMessageRecoverer(@Nullable MessageRecoverer messageRecoverer) {
        this.messageRecoverer = messageRecoverer;
    }

    protected void setRetrySettingsCustomizers(@Nullable List<RabbitListenerRetrySettingsCustomizer> retrySettingsCustomizers) {
        this.retrySettingsCustomizers = retrySettingsCustomizers;
    }

    public void setTaskExecutor(@Nullable Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected void setObservationConvention(@Nullable RabbitListenerObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }

    protected final RabbitProperties getRabbitProperties() {
        return this.rabbitProperties;
    }

    public abstract void configure(T var1, ConnectionFactory var2);

    protected void configure(T factory, ConnectionFactory connectionFactory, RabbitProperties.AmqpContainer configuration) {
        Assert.notNull(factory, (String)"'factory' must not be null");
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        Assert.notNull((Object)configuration, (String)"'configuration' must not be null");
        factory.setConnectionFactory(connectionFactory);
        if (this.messageConverter != null) {
            factory.setMessageConverter(this.messageConverter);
        }
        factory.setAutoStartup(Boolean.valueOf(configuration.isAutoStartup()));
        if (configuration.getAcknowledgeMode() != null) {
            factory.setAcknowledgeMode(configuration.getAcknowledgeMode());
        }
        if (configuration.getPrefetch() != null) {
            factory.setPrefetchCount(configuration.getPrefetch());
        }
        if (configuration.getDefaultRequeueRejected() != null) {
            factory.setDefaultRequeueRejected(configuration.getDefaultRequeueRejected());
        }
        if (configuration.getIdleEventInterval() != null) {
            factory.setIdleEventInterval(Long.valueOf(configuration.getIdleEventInterval().toMillis()));
        }
        factory.setMissingQueuesFatal(Boolean.valueOf(configuration.isMissingQueuesFatal()));
        factory.setDeBatchingEnabled(Boolean.valueOf(configuration.isDeBatchingEnabled()));
        factory.setForceStop(configuration.isForceStop());
        if (this.taskExecutor != null) {
            factory.setTaskExecutor(this.taskExecutor);
        }
        factory.setObservationEnabled(configuration.isObservationEnabled());
        RabbitProperties.ListenerRetry retryConfig = configuration.getRetry();
        if (retryConfig.isEnabled()) {
            RetryInterceptorBuilder.StatelessRetryInterceptorBuilder builder = retryConfig.isStateless() ? RetryInterceptorBuilder.stateless() : RetryInterceptorBuilder.stateful();
            builder.retryPolicy(this.createRetryPolicy(retryConfig));
            MessageRecoverer recoverer = this.messageRecoverer != null ? this.messageRecoverer : new RejectAndDontRequeueRecoverer();
            builder.recoverer(recoverer);
            factory.setAdviceChain(new Advice[]{builder.build()});
        }
        if (this.observationConvention != null) {
            factory.setObservationConvention(this.observationConvention);
        }
    }

    private RetryPolicy createRetryPolicy(RabbitProperties.Retry retryProperties) {
        RetryPolicySettings retrySettings = retryProperties.initializeRetryPolicySettings();
        if (this.retrySettingsCustomizers != null) {
            for (RabbitListenerRetrySettingsCustomizer customizer : this.retrySettingsCustomizers) {
                customizer.customize(retrySettings);
            }
        }
        return retrySettings.createRetryPolicy();
    }
}

