/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.health;

import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.util.Assert;

public class RabbitHealthIndicator
extends AbstractHealthIndicator {
    private final RabbitTemplate rabbitTemplate;

    public RabbitHealthIndicator(RabbitTemplate rabbitTemplate) {
        super("Rabbit health check failed");
        Assert.notNull((Object)rabbitTemplate, (String)"'rabbitTemplate' must not be null");
        this.rabbitTemplate = rabbitTemplate;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.up();
        String version = this.getVersion();
        if (version != null) {
            builder.withDetail("version", (Object)version);
        }
    }

    private @Nullable String getVersion() {
        return (String)this.rabbitTemplate.execute(channel -> {
            String version = channel.getConnection().getServerProperties().getOrDefault("version", "unknown");
            Assert.state((version != null ? 1 : 0) != 0, (String)"'version' must not be null");
            return version.toString();
        });
    }
}

