/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.health;

import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.util.Assert;

public class RabbitHealthIndicator
extends AbstractHealthIndicator {
    private final RabbitTemplate rabbitTemplate;

    public RabbitHealthIndicator(RabbitTemplate rabbitTemplate) {
        super("Rabbit health check failed");
        Assert.notNull((Object)rabbitTemplate, (String)"'rabbitTemplate' must not be null");
        this.rabbitTemplate = rabbitTemplate;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.up().withDetail("version", (Object)this.getVersion());
    }

    private String getVersion() {
        return (String)this.rabbitTemplate.execute(channel -> channel.getConnection().getServerProperties().get("version").toString());
    }
}

