/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.context.properties;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.context.properties.BeanSerializer;
import org.springframework.boot.context.properties.bind.BindConstructorProvider;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Name;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AccessorNamingStrategy;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import tools.jackson.databind.introspect.JacksonAnnotationIntrospector;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.BeanSerializerFactory;
import tools.jackson.databind.ser.FilterProvider;
import tools.jackson.databind.ser.PropertyWriter;
import tools.jackson.databind.ser.SerializerFactory;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.ser.std.SimpleBeanPropertyFilter;
import tools.jackson.databind.ser.std.SimpleFilterProvider;
import tools.jackson.databind.ser.std.ToStringSerializer;

class JacksonBeanSerializer
implements BeanSerializer {
    private static final String CONFIGURATION_PROPERTIES_FILTER_ID = "configurationPropertiesFilter";
    private final JsonMapper mapper;

    JacksonBeanSerializer() {
        JsonMapper.Builder builder = JsonMapper.builder();
        this.configureMapper(builder);
        this.mapper = builder.build();
    }

    private void configureMapper(JsonMapper.Builder builder) {
        builder.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        builder.changeDefaultPropertyInclusion(value -> value.withValueInclusion(JsonInclude.Include.NON_NULL));
        builder.accessorNaming((AccessorNamingStrategy.Provider)new DefaultAccessorNamingStrategy.Provider().withFirstCharAcceptance(true, false));
        this.applyConfigurationPropertiesFilter(builder);
        this.applySerializationModifier(builder);
        builder.addModule((JacksonModule)new ConfigurationPropertiesModule());
    }

    private void applyConfigurationPropertiesFilter(JsonMapper.Builder builder) {
        builder.annotationIntrospector((AnnotationIntrospector)new ConfigurationPropertiesAnnotationIntrospector());
        ConfigurationPropertiesPropertyFilter filter = new ConfigurationPropertiesPropertyFilter();
        builder.filterProvider((FilterProvider)new SimpleFilterProvider().setDefaultFilter((SimpleBeanPropertyFilter)filter));
    }

    private void applySerializationModifier(JsonMapper.Builder builder) {
        SerializerFactory factory = BeanSerializerFactory.instance.withSerializerModifier((ValueSerializerModifier)new GenericSerializerModifier());
        builder.serializerFactory(factory);
    }

    @Override
    public Map<String, @Nullable Object> serialize(@Nullable Object bean) {
        return (Map)this.mapper.convertValue(bean, Map.class);
    }

    private static final class ConfigurationPropertiesModule
    extends SimpleModule {
        private ConfigurationPropertiesModule() {
            this.addSerializer(DataSize.class, (ValueSerializer)ToStringSerializer.instance);
        }
    }

    private static final class ConfigurationPropertiesAnnotationIntrospector
    extends JacksonAnnotationIntrospector {
        private ConfigurationPropertiesAnnotationIntrospector() {
        }

        public Object findFilterId(MapperConfig<?> config, Annotated a) {
            Object id = super.findFilterId(config, a);
            return id != null ? id : JacksonBeanSerializer.CONFIGURATION_PROPERTIES_FILTER_ID;
        }
    }

    private static final class ConfigurationPropertiesPropertyFilter
    extends SimpleBeanPropertyFilter {
        private static final Log logger = LogFactory.getLog(ConfigurationPropertiesPropertyFilter.class);

        private ConfigurationPropertiesPropertyFilter() {
        }

        protected boolean include(BeanPropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        protected boolean include(PropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        private boolean include(String name) {
            return !name.startsWith("$$");
        }

        public void serializeAsProperty(Object pojo, JsonGenerator jgen, SerializationContext context, PropertyWriter writer) throws Exception {
            if (writer instanceof BeanPropertyWriter) {
                BeanPropertyWriter beanPropertyWriter = (BeanPropertyWriter)writer;
                try {
                    if (pojo == beanPropertyWriter.get(pojo)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Skipping '" + String.valueOf(writer.getFullName()) + "' on '" + pojo.getClass().getName() + "' as it is self-referential"));
                        }
                        return;
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Skipping '" + String.valueOf(writer.getFullName()) + "' on '" + pojo.getClass().getName() + "' as an exception was thrown when retrieving its value"), (Throwable)ex);
                    }
                    return;
                }
            }
            super.serializeAsProperty(pojo, jgen, context, writer);
        }
    }

    protected static class GenericSerializerModifier
    extends ValueSerializerModifier {
        private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

        protected GenericSerializerModifier() {
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription.Supplier beanDesc, List<BeanPropertyWriter> beanProperties) {
            ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>();
            Class beanClass = beanDesc.getType().getRawClass();
            Bindable bindable = Bindable.of((Class)ClassUtils.getUserClass((Class)beanClass));
            Constructor bindConstructor = BindConstructorProvider.DEFAULT.getBindConstructor(bindable, false);
            for (BeanPropertyWriter writer : beanProperties) {
                if (!this.isCandidate(beanDesc, writer, bindConstructor)) continue;
                result.add(writer);
            }
            return result;
        }

        private boolean isCandidate(BeanDescription.Supplier beanDesc, BeanPropertyWriter writer, @Nullable Constructor<?> constructor) {
            if (constructor != null) {
                Parameter[] parameters = constructor.getParameters();
                @Nullable String @Nullable [] names = parameterNameDiscoverer.getParameterNames(constructor);
                if (names == null) {
                    names = new String[parameters.length];
                }
                for (int i = 0; i < parameters.length; ++i) {
                    String name = MergedAnnotations.from((AnnotatedElement)parameters[i]).get(Name.class).getValue("value", String.class).orElse(names[i] != null ? names[i] : parameters[i].getName());
                    if (name == null || !name.equals(writer.getName())) continue;
                    return true;
                }
            }
            return this.isReadable(beanDesc, writer);
        }

        private boolean isReadable(BeanDescription.Supplier beanDesc, BeanPropertyWriter writer) {
            Class parentType = beanDesc.get().getType().getRawClass();
            Class type = writer.getType().getRawClass();
            AnnotatedMethod setter = this.findSetter(beanDesc.get(), writer);
            return setter != null || ClassUtils.getPackageName((Class)parentType).equals(ClassUtils.getPackageName((Class)type)) || Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type);
        }

        private @Nullable AnnotatedMethod findSetter(BeanDescription beanDesc, BeanPropertyWriter writer) {
            Class type;
            String name = "set" + this.determineAccessorSuffix(writer.getName());
            AnnotatedMethod setter = beanDesc.findMethod(name, new Class[]{type = writer.getType().getRawClass()});
            if (setter == null && type.equals(Boolean.TYPE)) {
                setter = beanDesc.findMethod(name, new Class[]{Boolean.class});
            }
            return setter;
        }

        private String determineAccessorSuffix(String propertyName) {
            if (propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1))) {
                return propertyName;
            }
            return StringUtils.capitalize((String)propertyName);
        }
    }
}

