/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.env;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.SanitizableData;
import org.springframework.boot.actuate.endpoint.Sanitizer;
import org.springframework.boot.actuate.endpoint.SanitizingFunction;
import org.springframework.boot.actuate.endpoint.Show;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.OptionalParameter;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Endpoint(id="env")
public class EnvironmentEndpoint {
    private final Sanitizer sanitizer;
    private final Environment environment;
    private final Show showValues;

    public EnvironmentEndpoint(Environment environment, Iterable<SanitizingFunction> sanitizingFunctions, Show showValues) {
        this.environment = environment;
        this.sanitizer = new Sanitizer(sanitizingFunctions);
        this.showValues = showValues;
    }

    @ReadOperation
    public EnvironmentDescriptor environment(@OptionalParameter String pattern) {
        boolean showUnsanitized = this.showValues.isShown(true);
        return this.getEnvironmentDescriptor(pattern, showUnsanitized);
    }

    EnvironmentDescriptor getEnvironmentDescriptor(String pattern, boolean showUnsanitized) {
        if (StringUtils.hasText((String)pattern)) {
            return this.getEnvironmentDescriptor(Pattern.compile(pattern).asPredicate(), showUnsanitized);
        }
        return this.getEnvironmentDescriptor((String name) -> true, showUnsanitized);
    }

    private EnvironmentDescriptor getEnvironmentDescriptor(Predicate<String> propertyNamePredicate, boolean showUnsanitized) {
        ArrayList<PropertySourceDescriptor> propertySources = new ArrayList<PropertySourceDescriptor>();
        this.getPropertySourcesAsMap().forEach((sourceName, source) -> {
            if (source instanceof EnumerablePropertySource) {
                propertySources.add(this.describeSource((String)sourceName, (EnumerablePropertySource<?>)((EnumerablePropertySource)source), propertyNamePredicate, showUnsanitized));
            }
        });
        return new EnvironmentDescriptor(Arrays.asList(this.environment.getActiveProfiles()), Arrays.asList(this.environment.getDefaultProfiles()), propertySources);
    }

    @ReadOperation
    public EnvironmentEntryDescriptor environmentEntry(@Selector String toMatch) {
        boolean showUnsanitized = this.showValues.isShown(true);
        return this.getEnvironmentEntryDescriptor(toMatch, showUnsanitized);
    }

    EnvironmentEntryDescriptor getEnvironmentEntryDescriptor(String propertyName, boolean showUnsanitized) {
        Map<String, PropertyValueDescriptor> descriptors = this.getPropertySourceDescriptors(propertyName, showUnsanitized);
        PropertySummaryDescriptor summary = this.getPropertySummaryDescriptor(descriptors);
        return new EnvironmentEntryDescriptor(summary, Arrays.asList(this.environment.getActiveProfiles()), Arrays.asList(this.environment.getDefaultProfiles()), this.toPropertySourceDescriptors(descriptors));
    }

    private List<PropertySourceEntryDescriptor> toPropertySourceDescriptors(Map<String, PropertyValueDescriptor> descriptors) {
        ArrayList<PropertySourceEntryDescriptor> result = new ArrayList<PropertySourceEntryDescriptor>();
        descriptors.forEach((name, property) -> result.add(new PropertySourceEntryDescriptor((String)name, (PropertyValueDescriptor)property)));
        return result;
    }

    private @Nullable PropertySummaryDescriptor getPropertySummaryDescriptor(Map<String, PropertyValueDescriptor> descriptors) {
        for (Map.Entry<String, PropertyValueDescriptor> entry : descriptors.entrySet()) {
            if (entry.getValue() == null) continue;
            return new PropertySummaryDescriptor(entry.getKey(), entry.getValue().getValue());
        }
        return null;
    }

    private Map<String, PropertyValueDescriptor> getPropertySourceDescriptors(String propertyName, boolean showUnsanitized) {
        LinkedHashMap<String, PropertyValueDescriptor> propertySources = new LinkedHashMap<String, PropertyValueDescriptor>();
        this.getPropertySourcesAsMap().forEach((sourceName, source) -> propertySources.put((String)sourceName, source.containsProperty(propertyName) ? this.describeValueOf(propertyName, (PropertySource<?>)source, showUnsanitized) : null));
        return propertySources;
    }

    private PropertySourceDescriptor describeSource(String sourceName, EnumerablePropertySource<?> source, Predicate<String> namePredicate, boolean showUnsanitized) {
        LinkedHashMap<String, PropertyValueDescriptor> properties = new LinkedHashMap<String, PropertyValueDescriptor>();
        Stream.of(source.getPropertyNames()).filter(namePredicate).forEach(name -> properties.put((String)name, this.describeValueOf((String)name, (PropertySource<?>)source, showUnsanitized)));
        return new PropertySourceDescriptor(sourceName, properties);
    }

    private PropertyValueDescriptor describeValueOf(String name, PropertySource<?> source, boolean showUnsanitized) {
        PropertySourcesPlaceholdersResolver resolver = new PropertySourcesPlaceholdersResolver((Iterable)this.getPropertySources());
        Object resolved = resolver.resolvePlaceholders(source.getProperty(name));
        Origin origin = source instanceof OriginLookup ? ((OriginLookup)source).getOrigin((Object)name) : null;
        Object sanitizedValue = this.sanitize(source, name, resolved, showUnsanitized);
        return new PropertyValueDescriptor(this.stringifyIfNecessary(sanitizedValue), origin);
    }

    private Map<String, PropertySource<?>> getPropertySourcesAsMap() {
        LinkedHashMap map = new LinkedHashMap();
        for (PropertySource source : this.getPropertySources()) {
            if (ConfigurationPropertySources.isAttachedConfigurationPropertySource((PropertySource)source)) continue;
            this.extract("", map, source);
        }
        return map;
    }

    private MutablePropertySources getPropertySources() {
        Environment environment = this.environment;
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
            return configurableEnvironment.getPropertySources();
        }
        return new StandardEnvironment().getPropertySources();
    }

    private void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            CompositePropertySource compositePropertySource = (CompositePropertySource)source;
            for (PropertySource nest : compositePropertySource.getPropertySources()) {
                this.extract(source.getName() + ":", map, nest);
            }
        } else {
            map.put(root + source.getName(), source);
        }
    }

    private @Nullable Object sanitize(PropertySource<?> source, String name, @Nullable Object value, boolean showUnsanitized) {
        return this.sanitizer.sanitize(new SanitizableData(source, name, value), showUnsanitized);
    }

    protected @Nullable Object stringifyIfNecessary(@Nullable Object value) {
        if (value == null || ClassUtils.isPrimitiveOrWrapper(value.getClass()) || Number.class.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (CharSequence.class.isAssignableFrom(value.getClass())) {
            return value.toString();
        }
        return "Complex property type " + value.getClass().getName();
    }

    public static final class EnvironmentDescriptor
    implements OperationResponseBody {
        private final List<String> activeProfiles;
        private final List<String> defaultProfiles;
        private final List<PropertySourceDescriptor> propertySources;

        private EnvironmentDescriptor(List<String> activeProfiles, List<String> defaultProfiles, List<PropertySourceDescriptor> propertySources) {
            this.activeProfiles = activeProfiles;
            this.defaultProfiles = defaultProfiles;
            this.propertySources = propertySources;
        }

        public List<String> getActiveProfiles() {
            return this.activeProfiles;
        }

        public List<String> getDefaultProfiles() {
            return this.defaultProfiles;
        }

        public List<PropertySourceDescriptor> getPropertySources() {
            return this.propertySources;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class EnvironmentEntryDescriptor {
        private final @Nullable PropertySummaryDescriptor property;
        private final List<String> activeProfiles;
        private final List<String> defaultProfiles;
        private final List<PropertySourceEntryDescriptor> propertySources;

        EnvironmentEntryDescriptor(@Nullable PropertySummaryDescriptor property, List<String> activeProfiles, List<String> defaultProfiles, List<PropertySourceEntryDescriptor> propertySources) {
            this.property = property;
            this.activeProfiles = activeProfiles;
            this.defaultProfiles = defaultProfiles;
            this.propertySources = propertySources;
        }

        public @Nullable PropertySummaryDescriptor getProperty() {
            return this.property;
        }

        public List<String> getActiveProfiles() {
            return this.activeProfiles;
        }

        public List<String> getDefaultProfiles() {
            return this.defaultProfiles;
        }

        public List<PropertySourceEntryDescriptor> getPropertySources() {
            return this.propertySources;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class PropertySummaryDescriptor {
        private final String source;
        private final @Nullable Object value;

        public PropertySummaryDescriptor(String source, @Nullable Object value) {
            this.source = source;
            this.value = value;
        }

        public String getSource() {
            return this.source;
        }

        public @Nullable Object getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class PropertyValueDescriptor {
        private final @Nullable Object value;
        private final @Nullable String origin;
        private final String @Nullable [] originParents;

        private PropertyValueDescriptor(@Nullable Object value, @Nullable Origin origin) {
            this.value = value;
            this.origin = origin != null ? origin.toString() : null;
            List originParents = Origin.parentsFrom((Object)origin);
            this.originParents = originParents.isEmpty() ? null : (String[])originParents.stream().map(Object::toString).toArray(String[]::new);
        }

        public @Nullable Object getValue() {
            return this.value;
        }

        public @Nullable String getOrigin() {
            return this.origin;
        }

        public String @Nullable [] getOriginParents() {
            return this.originParents;
        }
    }

    public static final class PropertySourceDescriptor {
        private final String name;
        private final Map<String, PropertyValueDescriptor> properties;

        private PropertySourceDescriptor(String name, Map<String, PropertyValueDescriptor> properties) {
            this.name = name;
            this.properties = properties;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, PropertyValueDescriptor> getProperties() {
            return this.properties;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class PropertySourceEntryDescriptor {
        private final String name;
        private final PropertyValueDescriptor property;

        private PropertySourceEntryDescriptor(String name, PropertyValueDescriptor property) {
            this.name = name;
            this.property = property;
        }

        public String getName() {
            return this.name;
        }

        public PropertyValueDescriptor getProperty() {
            return this.property;
        }
    }
}

