/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.invoke.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.function.Predicate;
import org.springframework.boot.actuate.endpoint.invoke.OperationParameter;
import org.springframework.core.Nullness;

class OperationMethodParameter
implements OperationParameter {
    private final String name;
    private final Parameter parameter;
    private final Predicate<Parameter> optional;

    OperationMethodParameter(String name, Parameter parameter, Predicate<Parameter> optionalParameters) {
        this.name = name;
        this.parameter = parameter;
        this.optional = optionalParameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.parameter.getType();
    }

    @Override
    public boolean isMandatory() {
        return !this.isOptional();
    }

    private boolean isOptional() {
        return Nullness.NULLABLE == Nullness.forParameter((Parameter)this.parameter) || this.optional.test(this.parameter);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        return this.parameter.getAnnotation(annotation);
    }

    public String toString() {
        return this.name + " of type " + this.parameter.getType().getName();
    }
}

