/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.availability;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.Status;
import org.springframework.util.Assert;

public class AvailabilityStateHealthIndicator
extends AbstractHealthIndicator {
    private final ApplicationAvailability applicationAvailability;
    private final Class<? extends AvailabilityState> stateType;
    private final Map<AvailabilityState, Status> statusMappings = new HashMap<AvailabilityState, Status>();

    public <S extends AvailabilityState> AvailabilityStateHealthIndicator(ApplicationAvailability applicationAvailability, Class<S> stateType, Consumer<StatusMappings<S>> statusMappings) {
        Assert.notNull((Object)applicationAvailability, (String)"'applicationAvailability' must not be null");
        Assert.notNull(stateType, (String)"'stateType' must not be null");
        Assert.notNull(statusMappings, (String)"'statusMappings' must not be null");
        this.applicationAvailability = applicationAvailability;
        this.stateType = stateType;
        statusMappings.accept(this.statusMappings::put);
        this.assertAllEnumsMapped(stateType);
    }

    private <S extends AvailabilityState> void assertAllEnumsMapped(Class<S> stateType) {
        if (!this.statusMappings.containsKey(null) && Enum.class.isAssignableFrom(stateType)) {
            EnumSet elements = EnumSet.allOf(stateType);
            for (Object element : elements) {
                Assert.state((boolean)this.statusMappings.containsKey(element), () -> "StatusMappings does not include " + String.valueOf(element));
            }
        }
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        AvailabilityState state = this.getState(this.applicationAvailability);
        Status status = this.statusMappings.get(state);
        if (status == null) {
            status = this.statusMappings.get(null);
        }
        Assert.state((status != null ? 1 : 0) != 0, () -> "No mapping provided for " + String.valueOf(state));
        builder.status(status);
    }

    protected @Nullable AvailabilityState getState(ApplicationAvailability applicationAvailability) {
        return applicationAvailability.getState(this.stateType);
    }

    public static interface StatusMappings<S extends AvailabilityState> {
        default public void addDefaultStatus(Status status) {
            this.add(null, status);
        }

        public void add(@Nullable S var1, Status var2);
    }
}

