/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.ApiVersion;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.health.AdditionalHealthEndpointPath;
import org.springframework.boot.actuate.health.CompositeHealthDescriptor;
import org.springframework.boot.actuate.health.Contributor;
import org.springframework.boot.actuate.health.HealthDescriptor;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.actuate.health.SystemHealthDescriptor;
import org.springframework.boot.convert.DurationStyle;
import org.springframework.boot.health.contributor.Status;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class HealthEndpointSupport<H, D> {
    static final String[] EMPTY_PATH = new String[0];
    private static final Log logger = LogFactory.getLog(HealthEndpointSupport.class);
    private final Contributor<H, D> rootContributor;
    private final HealthEndpointGroups groups;
    private final Duration slowContributorLoggingThreshold;

    HealthEndpointSupport(Contributor<H, D> rootContributor, HealthEndpointGroups groups, Duration slowContributorLoggingThreshold) {
        Assert.notNull(rootContributor, (String)"'rootContributor' must not be null");
        Assert.notNull((Object)groups, (String)"'groups' must not be null");
        this.rootContributor = rootContributor;
        this.groups = groups;
        this.slowContributorLoggingThreshold = slowContributorLoggingThreshold;
    }

    Result<D> getResult(ApiVersion apiVersion, WebServerNamespace serverNamespace, SecurityContext securityContext, boolean showAll, String ... path) {
        HealthEndpointGroup group;
        HealthEndpointGroup healthEndpointGroup = group = path.length > 0 ? this.getGroup(serverNamespace, path) : null;
        if (group != null) {
            return this.getResult(apiVersion, group, securityContext, showAll, path, 1);
        }
        return this.getResult(apiVersion, this.groups.getPrimary(), securityContext, showAll, path, 0);
    }

    private HealthEndpointGroup getGroup(WebServerNamespace serverNamespace, String ... path) {
        if (this.groups.get(path[0]) != null) {
            return this.groups.get(path[0]);
        }
        if (serverNamespace != null) {
            return this.groups.get(AdditionalHealthEndpointPath.of(serverNamespace, path[0]));
        }
        return null;
    }

    private Result<D> getResult(ApiVersion apiVersion, HealthEndpointGroup group, SecurityContext securityContext, boolean showAll, String[] path, int pathOffset) {
        boolean isRoot;
        boolean showComponents = showAll || group.showComponents(securityContext);
        boolean showDetails = showAll || group.showDetails(securityContext);
        boolean isSystemHealth = group == this.groups.getPrimary() && pathOffset == 0;
        boolean bl = isRoot = path.length - pathOffset == 0;
        if (!showComponents && !isRoot) {
            return null;
        }
        Contributor<H, D> contributor = this.getContributor(path, pathOffset);
        if (contributor == null) {
            return null;
        }
        String name = this.getName(path, pathOffset);
        TreeSet<String> groupNames = !isSystemHealth ? null : new TreeSet<String>(this.groups.getNames());
        D descriptor = this.getDescriptor(apiVersion, group, name, contributor, showComponents, showDetails, groupNames);
        return descriptor != null ? new Result<D>(descriptor, group) : null;
    }

    private Contributor<H, D> getContributor(String[] path, int pathOffset) {
        Contributor<H, D> contributor = this.rootContributor;
        while (pathOffset < path.length) {
            if (!contributor.isComposite()) {
                return null;
            }
            contributor = contributor.getChild(path[pathOffset]);
            ++pathOffset;
        }
        return contributor;
    }

    private String getName(String[] path, int pathOffset) {
        StringBuilder name = new StringBuilder();
        while (pathOffset < path.length) {
            name.append(!name.isEmpty() ? "/" : "");
            name.append(path[pathOffset]);
            ++pathOffset;
        }
        return name.toString();
    }

    private D getDescriptor(ApiVersion apiVersion, HealthEndpointGroup group, String name, Contributor<H, D> contributor, boolean showComponents, boolean showDetails, Set<String> groupNames) {
        if (contributor.isComposite()) {
            return this.getAggregateDescriptor(apiVersion, group, name, contributor, showComponents, showDetails, groupNames);
        }
        if (name.isEmpty() || group.isMember(name)) {
            return this.getDescriptorAndLogIfSlow(contributor, name, showDetails);
        }
        return null;
    }

    private D getAggregateDescriptor(ApiVersion apiVersion, HealthEndpointGroup group, String name, Contributor<H, D> contributor, boolean showComponents, boolean showDetails, Set<String> groupNames) {
        Object prefix = StringUtils.hasText((String)name) ? name + "/" : "";
        LinkedHashMap descriptors = new LinkedHashMap();
        for (Contributor.Child child : contributor) {
            String childName = child.name();
            Object descriptor = this.getDescriptor(apiVersion, group, (String)prefix + childName, child.contributor(), showComponents, showDetails, null);
            if (descriptor == null) continue;
            descriptors.put(childName, descriptor);
        }
        if (descriptors.isEmpty()) {
            return null;
        }
        return (D)this.aggregateDescriptors(apiVersion, descriptors, group.getStatusAggregator(), showComponents, groupNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private D getDescriptorAndLogIfSlow(Contributor<H, D> contributor, String name, boolean showDetails) {
        Instant start = Instant.now();
        try {
            D d = contributor.getDescriptor(showDetails);
            return d;
        }
        finally {
            Duration duration;
            if (logger.isWarnEnabled() && this.slowContributorLoggingThreshold != null && (duration = Duration.between(start, Instant.now())).compareTo(this.slowContributorLoggingThreshold) > 0) {
                logger.warn((Object)LogMessage.format((String)"Health contributor %s took %s to respond", (Object)contributor.getIdentifier(name), (Object)DurationStyle.SIMPLE.print(duration)));
            }
        }
    }

    abstract D aggregateDescriptors(ApiVersion var1, Map<String, D> var2, StatusAggregator var3, boolean var4, Set<String> var5);

    final CompositeHealthDescriptor getCompositeDescriptor(ApiVersion apiVersion, Map<String, HealthDescriptor> descriptors, StatusAggregator statusAggregator, boolean showComponents, Set<String> groupNames) {
        Status status = statusAggregator.getAggregateStatus(descriptors.values().stream().map(this::getStatus).collect(Collectors.toSet()));
        descriptors = !showComponents ? null : descriptors;
        return groupNames != null ? new SystemHealthDescriptor(apiVersion, status, descriptors, groupNames) : new CompositeHealthDescriptor(apiVersion, status, descriptors);
    }

    private Status getStatus(HealthDescriptor component) {
        return component != null ? component.getStatus() : Status.UNKNOWN;
    }

    record Result<D>(D descriptor, HealthEndpointGroup group) {
    }
}

