/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.web.mappings.servlet;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.web.mappings.MappingDescriptionProvider;
import org.springframework.boot.actuate.web.mappings.servlet.FilterRegistrationMappingDescription;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.aot.BindingReflectionHintsRegistrar;
import org.springframework.web.context.WebApplicationContext;

@ImportRuntimeHints(value={FiltersMappingDescriptionProviderRuntimeHints.class})
public class FiltersMappingDescriptionProvider
implements MappingDescriptionProvider {
    @Override
    public List<FilterRegistrationMappingDescription> describeMappings(ApplicationContext context) {
        if (context instanceof WebApplicationContext) {
            WebApplicationContext webApplicationContext = (WebApplicationContext)context;
            return webApplicationContext.getServletContext().getFilterRegistrations().values().stream().map(FilterRegistrationMappingDescription::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public String getMappingName() {
        return "servletFilters";
    }

    static class FiltersMappingDescriptionProviderRuntimeHints
    implements RuntimeHintsRegistrar {
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        FiltersMappingDescriptionProviderRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{FilterRegistrationMappingDescription.class});
        }
    }
}

